/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryUpdateJndiHandler;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryRemove;

public class ExternalConnectionFactoryDefinition
extends PersistentResourceDefinition {
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.HA, ConnectionFactoryAttributes.Regular.FACTORY_TYPE, ConnectionFactoryAttributes.Common.DISCOVERY_GROUP, ConnectionFactoryAttributes.Common.CONNECTORS, ConnectionFactoryAttributes.Common.ENTRIES};
    private final boolean registerRuntimeOnly;

    public ExternalConnectionFactoryDefinition(boolean registerRuntimeOnly) {
        super(MessagingExtension.CONNECTION_FACTORY_PATH, MessagingExtension.getResourceDescriptionResolver("connection-factory"), (OperationStepHandler)ExternalConnectionFactoryAdd.INSTANCE, (OperationStepHandler)ExternalConnectionFactoryRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            ConnectionFactoryUpdateJndiHandler.registerOperations(registry, this.getResourceDescriptionResolver());
        }
    }
}

