/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.spi.ClusteringDefaultRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.extension.messaging.activemq.BinderServiceUtil;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryType;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ExternalConnectionFactoryAdd
extends AbstractAddStepHandler {
    private static final ServiceName JBOSS_MESSAGING_ACTIVEMQ = ServiceName.JBOSS.append(new String[]{"messaging-activemq"});
    public static final ExternalConnectionFactoryAdd INSTANCE = new ExternalConnectionFactoryAdd();

    private ExternalConnectionFactoryAdd() {
        super(ExternalConnectionFactoryDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ExternalConnectionFactoryService service;
        String name = context.getCurrentAddressValue();
        ServiceName serviceName = ExternalConnectionFactoryDefinition.CAPABILITY.getCapabilityServiceName(context.getCurrentAddress());
        boolean ha = CommonAttributes.HA.resolveModelAttribute(context, model).asBoolean();
        ModelNode discoveryGroupName = ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.resolveModelAttribute(context, model);
        JMSFactoryType jmsFactoryType = ConnectionFactoryType.valueOf(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.resolveModelAttribute(context, model).asString()).getType();
        List connectorNames = ConnectionFactoryAttributes.Common.CONNECTORS.unwrap((ExpressionResolver)context, model);
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName).addAliases(new ServiceName[]{MessagingServices.getActiveMQServiceName(name)});
        if (discoveryGroupName.isDefined()) {
            HashMap<String, String> clusterNames = new HashMap<String, String>();
            HashMap<String, Supplier<SocketBinding>> groupBindings = new HashMap<String, Supplier<SocketBinding>>();
            HashMap<String, Supplier<CommandDispatcherFactory>> commandDispatcherFactories = new HashMap<String, Supplier<CommandDispatcherFactory>>();
            String dgname = discoveryGroupName.asString();
            String key = "discovery" + dgname;
            PathAddress dgAddress = context.getCurrentAddress().getParent().append("discovery-group", dgname);
            ModelNode discoveryGroupModel = context.readResourceFromRoot(dgAddress).getModel();
            if (discoveryGroupModel.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName())) {
                ModelNode channel = DiscoveryGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, discoveryGroupModel);
                ServiceName commandDispatcherFactoryServiceName = channel.isDefined() ? ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context, channel.asString()) : ClusteringDefaultRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context);
                String clusterName = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, discoveryGroupModel).asString();
                Supplier commandDispatcherFactorySupplier = builder.requires(commandDispatcherFactoryServiceName);
                commandDispatcherFactories.put(key, commandDispatcherFactorySupplier);
                clusterNames.put(key, clusterName);
            } else {
                ServiceName groupBinding = GroupBindingService.getDiscoveryBaseServiceName(JBOSS_MESSAGING_ACTIVEMQ).append(new String[]{name});
                Supplier groupBindingSupplier = builder.requires(groupBinding);
                groupBindings.put(key, groupBindingSupplier);
            }
            service = new ExternalConnectionFactoryService(ExternalConnectionFactoryAdd.getDiscoveryGroup(context, dgname), commandDispatcherFactories, groupBindings, clusterNames, jmsFactoryType, ha);
        } else {
            HashMap<String, Supplier<SocketBinding>> socketBindings = new HashMap<String, Supplier<SocketBinding>>();
            HashMap<String, Supplier<OutboundSocketBinding>> outboundSocketBindings = new HashMap<String, Supplier<OutboundSocketBinding>>();
            HashSet<String> connectorsSocketBindings = new HashSet<String>();
            TransportConfiguration[] transportConfigurations = TransportConfigOperationHandlers.processConnectors(context, connectorNames, connectorsSocketBindings);
            Map<String, Boolean> outbounds = TransportConfigOperationHandlers.listOutBoundSocketBinding(context, connectorsSocketBindings);
            for (String connectorSocketBinding : connectorsSocketBindings) {
                if (outbounds.get(connectorSocketBinding).booleanValue()) {
                    ServiceName outboundSocketName = OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{connectorSocketBinding});
                    Supplier outboundSupplier = builder.requires(outboundSocketName);
                    outboundSocketBindings.put(connectorSocketBinding, outboundSupplier);
                    continue;
                }
                ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{connectorSocketBinding});
                Supplier socketBindingsSupplier = builder.requires(socketName);
                socketBindings.put(connectorSocketBinding, socketBindingsSupplier);
            }
            service = new ExternalConnectionFactoryService(transportConfigurations, socketBindings, outboundSocketBindings, jmsFactoryType, ha);
        }
        builder.setInstance((Service)service);
        builder.install();
        for (String entry : ConnectionFactoryAttributes.Common.ENTRIES.unwrap((ExpressionResolver)context, model)) {
            MessagingLogger.ROOT_LOGGER.debugf("Referencing %s with JNDI name %s", serviceName, entry);
            BinderServiceUtil.installBinderService(context.getServiceTarget(), entry, service, serviceName);
        }
    }

    static DiscoveryGroupConfiguration getDiscoveryGroup(OperationContext context, String name) throws OperationFailedException {
        Resource discoveryGroup = context.readResourceFromRoot(context.getCurrentAddress().getParent().append(new PathElement[]{PathElement.pathElement((String)"discovery-group", (String)name)}), true);
        if (discoveryGroup != null) {
            long refreshTimeout = DiscoveryGroupDefinition.REFRESH_TIMEOUT.resolveModelAttribute(context, discoveryGroup.getModel()).asLong();
            long initialWaitTimeout = DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT.resolveModelAttribute(context, discoveryGroup.getModel()).asLong();
            return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout);
        }
        return null;
    }
}

