/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.List;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.ha.ScaleDownAttributes;

public class HAPolicyConfigurationBuilder {
    private static final HAPolicyConfigurationBuilder INSTANCE = new HAPolicyConfigurationBuilder();

    private HAPolicyConfigurationBuilder() {
    }

    public static HAPolicyConfigurationBuilder getInstance() {
        return INSTANCE;
    }

    public void addHAPolicyConfiguration(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        HAPolicyConfiguration haPolicyConfiguration;
        String type;
        if (!model.hasDefined("ha-policy")) {
            return;
        }
        Property prop = model.get("ha-policy").asProperty();
        ModelNode haPolicy = prop.getValue();
        switch (type = prop.getName()) {
            case "live-only": {
                haPolicyConfiguration = this.buildLiveOnlyConfiguration(context, haPolicy);
                break;
            }
            case "replication-master": {
                haPolicyConfiguration = this.buildReplicationMasterConfiguration(context, haPolicy);
                break;
            }
            case "replication-slave": {
                haPolicyConfiguration = this.buildReplicationSlaveConfiguration(context, haPolicy);
                break;
            }
            case "replication-colocated": {
                haPolicyConfiguration = this.buildReplicationColocatedConfiguration(context, haPolicy);
                break;
            }
            case "shared-store-master": {
                haPolicyConfiguration = this.buildSharedStoreMasterConfiguration(context, haPolicy);
                break;
            }
            case "shared-store-slave": {
                haPolicyConfiguration = this.buildSharedStoreSlaveConfiguration(context, haPolicy);
                break;
            }
            case "shared-store-colocated": {
                haPolicyConfiguration = this.buildSharedStoreColocatedConfiguration(context, haPolicy);
                break;
            }
            default: {
                throw new OperationFailedException("unknown ha policy type");
            }
        }
        configuration.setHAPolicyConfiguration(haPolicyConfiguration);
    }

    private HAPolicyConfiguration buildLiveOnlyConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ScaleDownConfiguration scaleDownConfiguration = ScaleDownAttributes.addScaleDownConfiguration(context, model);
        return new LiveOnlyPolicyConfiguration(scaleDownConfiguration);
    }

    private HAPolicyConfiguration buildReplicationMasterConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode groupName;
        ReplicatedPolicyConfiguration haPolicyConfiguration = new ReplicatedPolicyConfiguration();
        haPolicyConfiguration.setCheckForLiveServer(HAAttributes.CHECK_FOR_LIVE_SERVER.resolveModelAttribute(context, model).asBoolean()).setInitialReplicationSyncTimeout(HAAttributes.INITIAL_REPLICATION_SYNC_TIMEOUT.resolveModelAttribute(context, model).asLong());
        ModelNode clusterName = HAAttributes.CLUSTER_NAME.resolveModelAttribute(context, model);
        if (clusterName.isDefined()) {
            haPolicyConfiguration.setClusterName(clusterName.asString());
        }
        if ((groupName = HAAttributes.GROUP_NAME.resolveModelAttribute(context, model)).isDefined()) {
            haPolicyConfiguration.setGroupName(groupName.asString());
        }
        return haPolicyConfiguration;
    }

    private HAPolicyConfiguration buildReplicationSlaveConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode groupName;
        ReplicaPolicyConfiguration haPolicyConfiguration = new ReplicaPolicyConfiguration().setAllowFailBack(HAAttributes.ALLOW_FAILBACK.resolveModelAttribute(context, model).asBoolean()).setInitialReplicationSyncTimeout(HAAttributes.INITIAL_REPLICATION_SYNC_TIMEOUT.resolveModelAttribute(context, model).asLong()).setMaxSavedReplicatedJournalsSize(HAAttributes.MAX_SAVED_REPLICATED_JOURNAL_SIZE.resolveModelAttribute(context, model).asInt()).setScaleDownConfiguration(ScaleDownAttributes.addScaleDownConfiguration(context, model)).setRestartBackup(HAAttributes.RESTART_BACKUP.resolveModelAttribute(context, model).asBoolean());
        ModelNode clusterName = HAAttributes.CLUSTER_NAME.resolveModelAttribute(context, model);
        if (clusterName.isDefined()) {
            haPolicyConfiguration.setClusterName(clusterName.asString());
        }
        if ((groupName = HAAttributes.GROUP_NAME.resolveModelAttribute(context, model)).isDefined()) {
            haPolicyConfiguration.setGroupName(groupName.asString());
        }
        return haPolicyConfiguration;
    }

    private HAPolicyConfiguration buildReplicationColocatedConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ColocatedPolicyConfiguration haPolicyConfiguration = new ColocatedPolicyConfiguration().setRequestBackup(HAAttributes.REQUEST_BACKUP.resolveModelAttribute(context, model).asBoolean()).setBackupRequestRetries(HAAttributes.BACKUP_REQUEST_RETRIES.resolveModelAttribute(context, model).asInt()).setBackupRequestRetryInterval(HAAttributes.BACKUP_REQUEST_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong()).setMaxBackups(HAAttributes.MAX_BACKUPS.resolveModelAttribute(context, model).asInt()).setBackupPortOffset(HAAttributes.BACKUP_PORT_OFFSET.resolveModelAttribute(context, model).asInt());
        List connectors = HAAttributes.EXCLUDED_CONNECTORS.unwrap((ExpressionResolver)context, model);
        if (!connectors.isEmpty()) {
            haPolicyConfiguration.setExcludedConnectors(connectors);
        }
        ModelNode masterConfigurationModel = model.get(new String[]{"configuration", "master"});
        HAPolicyConfiguration masterConfiguration = this.buildReplicationMasterConfiguration(context, masterConfigurationModel);
        haPolicyConfiguration.setLiveConfig(masterConfiguration);
        ModelNode slaveConfigurationModel = model.get(new String[]{"configuration", "slave"});
        HAPolicyConfiguration slaveConfiguration = this.buildReplicationSlaveConfiguration(context, slaveConfigurationModel);
        haPolicyConfiguration.setBackupConfig(slaveConfiguration);
        return haPolicyConfiguration;
    }

    private HAPolicyConfiguration buildSharedStoreMasterConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        return new SharedStoreMasterPolicyConfiguration().setFailoverOnServerShutdown(HAAttributes.FAILOVER_ON_SERVER_SHUTDOWN.resolveModelAttribute(context, model).asBoolean());
    }

    private HAPolicyConfiguration buildSharedStoreSlaveConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        return new SharedStoreSlavePolicyConfiguration().setAllowFailBack(HAAttributes.ALLOW_FAILBACK.resolveModelAttribute(context, model).asBoolean()).setFailoverOnServerShutdown(HAAttributes.FAILOVER_ON_SERVER_SHUTDOWN.resolveModelAttribute(context, model).asBoolean()).setRestartBackup(HAAttributes.RESTART_BACKUP.resolveModelAttribute(context, model).asBoolean()).setScaleDownConfiguration(ScaleDownAttributes.addScaleDownConfiguration(context, model));
    }

    private HAPolicyConfiguration buildSharedStoreColocatedConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ColocatedPolicyConfiguration haPolicyConfiguration = new ColocatedPolicyConfiguration().setRequestBackup(HAAttributes.REQUEST_BACKUP.resolveModelAttribute(context, model).asBoolean()).setBackupRequestRetries(HAAttributes.BACKUP_REQUEST_RETRIES.resolveModelAttribute(context, model).asInt()).setBackupRequestRetryInterval(HAAttributes.BACKUP_REQUEST_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong()).setMaxBackups(HAAttributes.MAX_BACKUPS.resolveModelAttribute(context, model).asInt()).setBackupPortOffset(HAAttributes.BACKUP_PORT_OFFSET.resolveModelAttribute(context, model).asInt());
        ModelNode masterConfigurationModel = model.get(new String[]{"configuration", "master"});
        HAPolicyConfiguration masterConfiguration = this.buildSharedStoreMasterConfiguration(context, masterConfigurationModel);
        haPolicyConfiguration.setLiveConfig(masterConfiguration);
        ModelNode slaveConfigurationModel = model.get(new String[]{"configuration", "slave"});
        HAPolicyConfiguration slaveConfiguration = this.buildSharedStoreSlaveConfiguration(context, slaveConfigurationModel);
        haPolicyConfiguration.setBackupConfig(slaveConfiguration);
        return haPolicyConfiguration;
    }
}

