/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.services.net.SocketBindingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.spi.ClusteringDefaultRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.extension.messaging.activemq.BroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.Capabilities;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.ConfigurationHelper;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.ExternalBrokerConfigurationService;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.MessagingSubsystemRootResourceDefinition;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.deployment.DefaultJMSConnectionFactoryBindingProcessor;
import org.wildfly.extension.messaging.activemq.deployment.DefaultJMSConnectionFactoryResourceReferenceProcessor;
import org.wildfly.extension.messaging.activemq.deployment.JMSConnectionFactoryDefinitionAnnotationProcessor;
import org.wildfly.extension.messaging.activemq.deployment.JMSConnectionFactoryDefinitionDescriptorProcessor;
import org.wildfly.extension.messaging.activemq.deployment.JMSDestinationDefinitionAnnotationProcessor;
import org.wildfly.extension.messaging.activemq.deployment.JMSDestinationDefinitionDescriptorProcessor;
import org.wildfly.extension.messaging.activemq.deployment.MessagingDependencyProcessor;
import org.wildfly.extension.messaging.activemq.deployment.MessagingXmlInstallDeploymentUnitProcessor;
import org.wildfly.extension.messaging.activemq.deployment.MessagingXmlParsingDeploymentUnitProcessor;
import org.wildfly.extension.messaging.activemq.deployment.injection.CDIDeploymentProcessor;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

class MessagingSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private static final ServiceName JBOSS_MESSAGING_ACTIVEMQ = ServiceName.JBOSS.append(new String[]{"messaging-activemq"});
    public static final MessagingSubsystemAdd INSTANCE = new MessagingSubsystemAdd();

    private MessagingSubsystemAdd() {
        super(MessagingSubsystemRootResourceDefinition.ATTRIBUTES);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        MessagingServices.capabilityServiceSupport = context.getCapabilityServiceSupport();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("messaging-activemq", Phase.STRUCTURE, 7170, (DeploymentUnitProcessor)new DefaultJMSConnectionFactoryResourceReferenceProcessor());
                processorTarget.addDeploymentProcessor("messaging-activemq", Phase.PARSE, 11523, (DeploymentUnitProcessor)new JMSDestinationDefinitionAnnotationProcessor());
                processorTarget.addDeploymentProcessor("messaging-activemq", Phase.PARSE, 11524, (DeploymentUnitProcessor)new JMSConnectionFactoryDefinitionAnnotationProcessor());
                processorTarget.addDeploymentProcessor("messaging-activemq", Phase.PARSE, 17920, (DeploymentUnitProcessor)new MessagingXmlParsingDeploymentUnitProcessor());
                processorTarget.addDeploymentProcessor("messaging-activemq", Phase.DEPENDENCIES, 5120, (DeploymentUnitProcessor)new MessagingDependencyProcessor());
                if (MessagingServices.capabilityServiceSupport.hasCapability("org.wildfly.weld")) {
                    processorTarget.addDeploymentProcessor("messaging-activemq", Phase.POST_MODULE, 3840, (DeploymentUnitProcessor)new CDIDeploymentProcessor());
                }
                processorTarget.addDeploymentProcessor("messaging-activemq", Phase.POST_MODULE, 5892, (DeploymentUnitProcessor)new JMSConnectionFactoryDefinitionDescriptorProcessor());
                processorTarget.addDeploymentProcessor("messaging-activemq", Phase.POST_MODULE, 5891, (DeploymentUnitProcessor)new JMSDestinationDefinitionDescriptorProcessor());
                processorTarget.addDeploymentProcessor("messaging-activemq", Phase.INSTALL, 4432, (DeploymentUnitProcessor)new DefaultJMSConnectionFactoryBindingProcessor());
                processorTarget.addDeploymentProcessor("messaging-activemq", Phase.INSTALL, 8240, (DeploymentUnitProcessor)new MessagingXmlInstallDeploymentUnitProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        ModelNode threadPoolMaxSize = operation.get(MessagingSubsystemRootResourceDefinition.GLOBAL_CLIENT_THREAD_POOL_MAX_SIZE.getName());
        ModelNode scheduledThreadPoolMaxSize = operation.get(MessagingSubsystemRootResourceDefinition.GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_MAX_SIZE.getName());
        Properties sysprops = System.getProperties();
        Integer threadPoolMaxSizeValue = threadPoolMaxSize.isDefined() ? Integer.valueOf(MessagingSubsystemRootResourceDefinition.GLOBAL_CLIENT_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, operation).asInt()) : (sysprops.containsKey("activemq.artemis.client.global.thread.pool.max.size") ? Integer.valueOf(Integer.parseInt(sysprops.getProperty("activemq.artemis.client.global.thread.pool.max.size"))) : null);
        Integer scheduledThreadPoolMaxSizeValue = scheduledThreadPoolMaxSize.isDefined() ? Integer.valueOf(MessagingSubsystemRootResourceDefinition.GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, operation).asInt()) : (sysprops.containsKey("activemq.artemis.client.global.scheduled.thread.pool.core.size") ? Integer.valueOf(Integer.parseInt(sysprops.getProperty("activemq.artemis.client.global.scheduled.thread.pool.core.size"))) : null);
        if (threadPoolMaxSizeValue != null || scheduledThreadPoolMaxSizeValue != null) {
            ActiveMQClient.initializeGlobalThreadPoolProperties();
            if (threadPoolMaxSizeValue == null) {
                threadPoolMaxSizeValue = ActiveMQClient.getGlobalThreadPoolSize();
            }
            if (scheduledThreadPoolMaxSizeValue == null) {
                scheduledThreadPoolMaxSizeValue = ActiveMQClient.getGlobalScheduledThreadPoolSize();
            }
            MessagingLogger.ROOT_LOGGER.debugf("Setting global client thread pool size to: regular=%s, scheduled=%s", threadPoolMaxSizeValue, scheduledThreadPoolMaxSizeValue);
            ActiveMQClient.setGlobalThreadPoolProperties((int)threadPoolMaxSizeValue, (int)scheduledThreadPoolMaxSizeValue);
        }
        context.getServiceTarget().addService(MessagingServices.ACTIVEMQ_CLIENT_THREAD_POOL).setInstance((Service)new ThreadPoolService()).install();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName groupBindingServiceName;
                String clusterName;
                ServiceName commandDispatcherFactoryServiceName;
                ModelNode channel;
                String key;
                String name;
                ServiceTarget serviceTarget = context.getServiceTarget();
                ServiceBuilder serviceBuilder = serviceTarget.addService(MessagingSubsystemRootResourceDefinition.CONFIGURATION_CAPABILITY.getCapabilityServiceName());
                ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
                HashSet<String> connectorsSocketBindings = new HashSet<String>();
                Map<String, TransportConfiguration> connectors = TransportConfigOperationHandlers.processConnectors(context, "localhost", model, connectorsSocketBindings);
                HashMap<String, ServiceName> outboundSocketBindings = new HashMap<String, ServiceName>();
                Map<String, Boolean> outbounds = TransportConfigOperationHandlers.listOutBoundSocketBinding(context, connectorsSocketBindings);
                HashMap<String, ServiceName> socketBindings = new HashMap<String, ServiceName>();
                for (String connectorSocketBinding : connectorsSocketBindings) {
                    if (outbounds.get(connectorSocketBinding).booleanValue()) {
                        ServiceName outboundSocketName = Capabilities.OUTBOUND_SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(new String[]{connectorSocketBinding});
                        outboundSocketBindings.put(connectorSocketBinding, outboundSocketName);
                        continue;
                    }
                    if (socketBindings.containsKey(connectorSocketBinding)) continue;
                    socketBindings.put(connectorSocketBinding, SocketBindingResourceDefinition.SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(new String[]{connectorSocketBinding}));
                }
                ArrayList<BroadcastGroupConfiguration> broadcastGroupConfigurations = new ArrayList<BroadcastGroupConfiguration>();
                BroadcastGroupAdd.addBroadcastGroupConfigs(context, broadcastGroupConfigurations, connectors.keySet(), model);
                Map<String, DiscoveryGroupConfiguration> discoveryGroupConfigurations = ConfigurationHelper.addDiscoveryGroupConfigurations(context, model);
                HashMap<String, String> clusterNames = new HashMap<String, String>();
                HashMap<String, ServiceName> commandDispatcherFactories = new HashMap<String, ServiceName>();
                HashSet<ServiceName> commandDispatcherFactoryServices = new HashSet<ServiceName>();
                HashMap<String, ServiceName> groupBindings = new HashMap<String, ServiceName>();
                HashSet<ServiceName> groupBindingServices = new HashSet<ServiceName>();
                for (BroadcastGroupConfiguration broadcastGroupConfiguration : broadcastGroupConfigurations) {
                    name = broadcastGroupConfiguration.getName();
                    key = "broadcast" + name;
                    ModelNode broadcastGroupModel = model.get(new String[]{"broadcast-group", name});
                    if (broadcastGroupModel.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName())) {
                        channel = BroadcastGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, broadcastGroupModel);
                        commandDispatcherFactoryServiceName = channel.isDefined() ? ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context, channel.asString()) : ClusteringDefaultRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context);
                        clusterName = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, broadcastGroupModel).asString();
                        if (!commandDispatcherFactoryServices.contains(commandDispatcherFactoryServiceName)) {
                            commandDispatcherFactoryServices.add(commandDispatcherFactoryServiceName);
                        }
                        commandDispatcherFactories.put(key, commandDispatcherFactoryServiceName);
                        clusterNames.put(key, clusterName);
                        continue;
                    }
                    groupBindingServiceName = GroupBindingService.getBroadcastBaseServiceName(JBOSS_MESSAGING_ACTIVEMQ).append(new String[]{name});
                    if (!groupBindingServices.contains(groupBindingServiceName)) {
                        groupBindingServices.add(groupBindingServiceName);
                    }
                    groupBindings.put(key, groupBindingServiceName);
                }
                for (DiscoveryGroupConfiguration discoveryGroupConfiguration : discoveryGroupConfigurations.values()) {
                    name = discoveryGroupConfiguration.getName();
                    key = "discovery" + name;
                    ModelNode discoveryGroupModel = model.get(new String[]{"discovery-group", name});
                    if (discoveryGroupModel.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName())) {
                        channel = DiscoveryGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, discoveryGroupModel);
                        commandDispatcherFactoryServiceName = channel.isDefined() ? ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context, channel.asString()) : ClusteringDefaultRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context);
                        clusterName = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, discoveryGroupModel).asString();
                        if (!commandDispatcherFactoryServices.contains(commandDispatcherFactoryServiceName)) {
                            commandDispatcherFactoryServices.add(commandDispatcherFactoryServiceName);
                        }
                        commandDispatcherFactories.put(key, commandDispatcherFactoryServiceName);
                        clusterNames.put(key, clusterName);
                        continue;
                    }
                    groupBindingServiceName = GroupBindingService.getDiscoveryBaseServiceName(JBOSS_MESSAGING_ACTIVEMQ).append(new String[]{name});
                    if (!groupBindingServices.contains(groupBindingServiceName)) {
                        groupBindingServices.add(groupBindingServiceName);
                    }
                    groupBindings.put(key, groupBindingServiceName);
                }
                serviceBuilder.setInstance((Service)new ExternalBrokerConfigurationService(connectors, discoveryGroupConfigurations, socketBindings, outboundSocketBindings, groupBindings, commandDispatcherFactories, clusterNames)).install();
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private static class ThreadPoolService
    implements org.jboss.msc.service.Service<Void> {
        public void start(StartContext startContext) throws StartException {
        }

        public void stop(StopContext stopContext) {
            ActiveMQClient.clearThreadPools();
        }

        public Void getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }
    }
}

