/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.WildFlyMicrometerConfig;
import org.wildfly.extension.micrometer.jmx.JmxMicrometerCollector;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

class MicrometerRegistryService
implements Service {
    private final Consumer<WildFlyRegistry> registriesConsumer;
    private final WildFlyMicrometerConfig config;
    private WildFlyRegistry registry;

    static Supplier<WildFlyRegistry> install(OperationContext context, WildFlyMicrometerConfig config) {
        CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY);
        RegistrySupplier registrySupplier = new RegistrySupplier(serviceBuilder.provides(new ServiceName[]{MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName()}));
        serviceBuilder.setInstance((Service)new MicrometerRegistryService(registrySupplier, config)).install();
        return registrySupplier;
    }

    private MicrometerRegistryService(Consumer<WildFlyRegistry> registriesConsumer, WildFlyMicrometerConfig config) {
        this.registriesConsumer = registriesConsumer;
        this.config = config;
    }

    public void start(StartContext context) {
        this.registry = new WildFlyRegistry(this.config);
        try {
            new JmxMicrometerCollector(this.registry).init();
        }
        catch (IOException e) {
            throw MicrometerExtensionLogger.MICROMETER_LOGGER.failedInitializeJMXRegistrar(e);
        }
        this.registriesConsumer.accept(this.registry);
    }

    public void stop(StopContext context) {
        if (this.registry != null) {
            this.registry.close();
            this.registry = null;
        }
        this.registriesConsumer.accept(null);
    }

    private static final class RegistrySupplier
    implements Consumer<WildFlyRegistry>,
    Supplier<WildFlyRegistry> {
        private final Consumer<WildFlyRegistry> wrapped;
        private volatile WildFlyRegistry registry;

        private RegistrySupplier(Consumer<WildFlyRegistry> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void accept(WildFlyRegistry registry) {
            this.registry = registry;
            this.wrapped.accept(registry);
        }

        @Override
        public WildFlyRegistry get() {
            return this.registry;
        }
    }
}

