/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.util.List;
import java.util.function.Predicate;

public class WildFlyMicrometerConfig {
    private List<String> exposedSubsystems;
    private Predicate<String> subsystemFilter;

    public Predicate<String> getSubsystemFilter() {
        return this.subsystemFilter;
    }

    public static class Builder {
        private final WildFlyMicrometerConfig config = new WildFlyMicrometerConfig();

        public Builder exposedSubsystems(List<String> exposedSubsystems) {
            this.config.exposedSubsystems = exposedSubsystems;
            boolean exposeAnySubsystem = exposedSubsystems.remove("*");
            this.config.subsystemFilter = subsystem -> exposeAnySubsystem || exposedSubsystems.contains(subsystem);
            return this;
        }

        public WildFlyMicrometerConfig build() {
            return this.config;
        }
    }
}

