/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.otlp;

import io.micrometer.core.instrument.Clock;
import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.HistogramFlavor;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpMeterRegistry;
import java.security.AccessController;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.wildfly.extension.micrometer.WildFlyMicrometerConfig;
import org.wildfly.extension.micrometer.registry.WildFlyRegistry;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WildFlyOtlpRegistry
extends OtlpMeterRegistry
implements WildFlyRegistry {
    public WildFlyOtlpRegistry(WildFlyMicrometerOtlpConfig config) {
        super((OtlpConfig)config, Clock.SYSTEM);
    }

    public static class WildFlyMicrometerOtlpConfig
    extends WildFlyMicrometerConfig
    implements OtlpConfig {
        private String endpoint;
        private Long step;
        private List<String> exposedSubsystems;

        private WildFlyMicrometerOtlpConfig() {
        }

        public String url() {
            return this.endpoint;
        }

        public Duration step() {
            return Duration.ofSeconds(this.step);
        }

        public String get(String key) {
            return null;
        }

        public Map<String, String> resourceAttributes() {
            Map attributes = super.resourceAttributes();
            if (!attributes.containsKey("service.name")) {
                attributes.put("service.name", "wildfly");
            }
            return attributes;
        }

        public AggregationTemporality aggregationTemporality() {
            if (WildFlySecurityManager.isChecking()) {
                return AccessController.doPrivileged(() -> super.aggregationTemporality());
            }
            return super.aggregationTemporality();
        }

        public HistogramFlavor histogramFlavor() {
            if (WildFlySecurityManager.isChecking()) {
                return AccessController.doPrivileged(() -> super.histogramFlavor());
            }
            return super.histogramFlavor();
        }

        public Map<String, String> headers() {
            if (WildFlySecurityManager.isChecking()) {
                return AccessController.doPrivileged(() -> super.headers());
            }
            return super.headers();
        }

        public static class Builder {
            private final WildFlyMicrometerOtlpConfig config = new WildFlyMicrometerOtlpConfig();

            public Builder endpoint(String endpoint) {
                this.config.endpoint = endpoint;
                return this;
            }

            public Builder step(Long step) {
                this.config.step = step;
                return this;
            }

            public WildFlyMicrometerOtlpConfig build() {
                return this.config;
            }
        }
    }
}

