/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.extension.microprofile.config.ConfigSourceService;
import org.wildfly.extension.microprofile.config.MicroProfileConfigLogger;
import org.wildfly.extension.microprofile.config.SubsystemExtension;
import org.wildfly.microprofile.config.DirConfigSource;
import org.wildfly.microprofile.config.PropertiesConfigSource;

public class ConfigSourceDefinition
extends PersistentResourceDefinition {
    static AttributeDefinition ORDINAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ordinal", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(100))).setAllowNull(true)).setRestartAllServices()).build();
    static AttributeDefinition PROPERTIES = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("properties", true).setAttributeParser((AttributeParser)new AttributeParsers.PropertiesParser(false))).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.PropertiesAttributeMarshaller(null, false))).setAlternatives(new String[]{"class", "dir"})).setAllowNull(true)).setRestartAllServices()).build();
    static ObjectTypeAttributeDefinition CLASS = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"class", (AttributeDefinition[])new AttributeDefinition[]{((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).build()}).setAlternatives(new String[]{"properties", "dir"})).setAllowNull(true).setAttributeMarshaller(AttributeMarshaller.ATTRIBUTE_OBJECT)).build();
    static AttributeDefinition DIR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"dir", (ModelType)ModelType.STRING).setAllowExpression(true)).setAlternatives(new String[]{"class", "properties"})).setAllowNull(true)).setRestartAllServices()).build();
    static AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ORDINAL, PROPERTIES, CLASS, DIR};

    protected ConfigSourceDefinition() {
        super(SubsystemExtension.CONFIG_SOURCE_PATH, SubsystemExtension.getResourceDescriptionResolver(SubsystemExtension.CONFIG_SOURCE_PATH.getKey()), (OperationStepHandler)new AbstractAddStepHandler(ATTRIBUTES){

            protected boolean requiresRuntime(OperationContext context) {
                return true;
            }

            protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                ConfigSource configSource;
                super.performRuntime(context, operation, model);
                String name = context.getCurrentAddressValue();
                int ordinal = ORDINAL.resolveModelAttribute(context, model).asInt();
                ModelNode props = PROPERTIES.resolveModelAttribute(context, model);
                ModelNode classModel = CLASS.resolveModelAttribute(context, model);
                ModelNode dirModel = DIR.resolveModelAttribute(context, model);
                if (classModel.isDefined()) {
                    Class configSourceClass = ConfigSourceDefinition.unwrapClass(classModel);
                    try {
                        configSource = (ConfigSource)ConfigSource.class.cast(configSourceClass.newInstance());
                    }
                    catch (Exception e) {
                        throw new OperationFailedException((Throwable)e);
                    }
                } else if (dirModel.isDefined()) {
                    File dir = new File(dirModel.asString());
                    configSource = new DirConfigSource(dir, ordinal);
                } else {
                    Map properties = PropertiesAttributeDefinition.unwrapModel((ExpressionResolver)context, (ModelNode)props);
                    configSource = new PropertiesConfigSource(properties, name, ordinal);
                }
                MicroProfileConfigLogger.ROOT_LOGGER.info("Reading properties from " + configSource.getName());
                ConfigSourceService.install(context, name, configSource);
            }
        }, (OperationStepHandler)new AbstractRemoveStepHandler(){

            protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                String name = context.getCurrentAddressValue();
                context.removeService(ConfigSourceService.SERVICE_NAME.append(new String[]{name}));
            }
        });
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    private static Class unwrapClass(ModelNode classModel) throws OperationFailedException {
        String className = classModel.get("name").asString();
        String moduleName = classModel.get("module").asString();
        try {
            ModuleIdentifier moduleID = ModuleIdentifier.fromString((String)moduleName);
            Module module = Module.getCallerModuleLoader().loadModule(moduleID);
            Class clazz = module.getClassLoader().loadClass(className);
            return clazz;
        }
        catch (Exception e) {
            throw MicroProfileConfigLogger.ROOT_LOGGER.unableToLoadClassFromModule(className, moduleName);
        }
    }
}

