/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.deployment;

import java.util.List;
import javax.enterprise.inject.spi.Extension;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.microprofile.config.ServiceNames;
import org.wildfly.microprofile.config.WildFlyConfigBuilder;
import org.wildfly.microprofile.config.WildFlyConfigProviderResolver;
import org.wildfly.microprofile.config.inject.ConfigExtension;

public class SubsystemDeploymentProcessor
implements DeploymentUnitProcessor {
    Logger log = Logger.getLogger(SubsystemDeploymentProcessor.class);
    public static final Phase PHASE = Phase.POST_MODULE;
    public static final int PRIORITY = 16384;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        WildFlyConfigBuilder builder = new WildFlyConfigBuilder();
        builder.forClassLoader((ClassLoader)module.getClassLoader()).addDefaultSources().addDiscoveredSources().addDiscoveredConverters();
        this.addConfigSourcesFromServices((ConfigBuilder)builder, phaseContext.getServiceRegistry(), (ClassLoader)module.getClassLoader());
        Config config = builder.build();
        WildFlyConfigProviderResolver.INSTANCE.registerConfig(config, (ClassLoader)module.getClassLoader());
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)deploymentUnit);
            extensions.registerExtensionInstance((Extension)new ConfigExtension(), deploymentUnit);
        }
    }

    private void addConfigSourcesFromServices(ConfigBuilder builder, ServiceRegistry serviceRegistry, ClassLoader classloader) {
        List serviceNames = serviceRegistry.getServiceNames();
        for (ServiceName serviceName : serviceNames) {
            ServiceController service;
            if (ServiceNames.CONFIG_SOURCE.isParentOf(serviceName)) {
                service = serviceRegistry.getService(serviceName);
                ConfigSource configSource = (ConfigSource)ConfigSource.class.cast(service.getValue());
                builder.withSources(new ConfigSource[]{configSource});
                continue;
            }
            if (!ServiceNames.CONFIG_SOURCE_PROVIDER.isParentOf(serviceName)) continue;
            service = serviceRegistry.getService(serviceName);
            ConfigSourceProvider configSourceProvider = (ConfigSourceProvider)ConfigSourceProvider.class.cast(service.getValue());
            for (ConfigSource configSource : configSourceProvider.getConfigSources(classloader)) {
                builder.withSources(new ConfigSource[]{configSource});
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
        Module module = (Module)context.getAttachment(Attachments.MODULE);
        WildFlyConfigProviderResolver.INSTANCE.releaseConfig(ConfigProvider.getConfig((ClassLoader)module.getClassLoader()));
    }
}

