/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.config.inject;

import java.lang.reflect.Type;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.wildfly.microprofile.config.inject.ConfigInjectionBean;
import org.wildfly.microprofile.config.inject.ConfigProducer;

public class ConfigExtension
implements Extension {
    private Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();

    private void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        AnnotatedType configBean = bm.createAnnotatedType(ConfigProducer.class);
        bbd.addAnnotatedType(configBean);
    }

    public void collectConfigProducer(@Observes ProcessInjectionPoint<?, ?> pip) {
        ConfigProperty configProperty = (ConfigProperty)pip.getInjectionPoint().getAnnotated().getAnnotation(ConfigProperty.class);
        if (configProperty != null) {
            this.injectionPoints.add(pip.getInjectionPoint());
        }
    }

    public void registerConfigProducer(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        Set<Class> types = this.injectionPoints.stream().filter(ip -> ip.getType() instanceof Class && ip.getType() != String.class && ip.getType() != Boolean.class && ip.getType() != Boolean.TYPE && ip.getType() != Integer.class && ip.getType() != Integer.TYPE && ip.getType() != Long.class && ip.getType() != Long.TYPE && ip.getType() != Float.class && ip.getType() != Float.TYPE && ip.getType() != Double.class && ip.getType() != Double.TYPE && ip.getType() != Duration.class && ip.getType() != LocalDate.class && ip.getType() != LocalTime.class && ip.getType() != LocalDateTime.class).map(ip -> (Class)ip.getType()).collect(Collectors.toSet());
        types.forEach(type -> abd.addBean(new ConfigInjectionBean(bm, (Class)type)));
    }

    public void validate(@Observes AfterDeploymentValidation add, BeanManager bm) {
        ArrayList<String> deploymentProblems = new ArrayList<String>();
        Config config = ConfigProvider.getConfig();
        for (InjectionPoint injectionPoint : this.injectionPoints) {
            String defaultValue;
            String key;
            Type type = injectionPoint.getType();
            ConfigProperty configProperty = (ConfigProperty)injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
            if (!(type instanceof Class) || config.getOptionalValue(key = configProperty.name(), (Class)type).isPresent() || (defaultValue = configProperty.defaultValue()) != null && defaultValue.length() != 0 && !defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) continue;
            deploymentProblems.add("No Config Value exists for " + key);
        }
        if (!deploymentProblems.isEmpty()) {
            add.addDeploymentProblem((Throwable)new DeploymentException("Error while validating Configuration\n" + String.join((CharSequence)"\n", deploymentProblems)));
        }
    }
}

