/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.config.inject;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.wildfly.microprofile.config.WildFlyConfig;
import org.wildfly.microprofile.config.inject.ConfigExtension;

public class ConfigInjectionBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Set<Annotation> QUALIFIERS = new HashSet<Annotation>();
    private final BeanManager bm;
    private final Class clazz;
    private Config _config;

    public ConfigInjectionBean(BeanManager bm, Class clazz) {
        this.bm = bm;
        this.clazz = clazz;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.EMPTY_SET;
    }

    public Class<?> getBeanClass() {
        return ConfigInjectionBean.class;
    }

    public boolean isNullable() {
        return false;
    }

    public T create(CreationalContext<T> context) {
        Set beans = this.bm.getBeans(InjectionPoint.class, new Annotation[0]);
        Bean bean = this.bm.resolve(beans);
        InjectionPoint ip = (InjectionPoint)this.bm.getReference(bean, InjectionPoint.class, context);
        if (ip == null) {
            throw new IllegalStateException("Could not retrieve InjectionPoint");
        }
        Annotated annotated = ip.getAnnotated();
        ConfigProperty configProperty = (ConfigProperty)annotated.getAnnotation(ConfigProperty.class);
        String key = ConfigExtension.getConfigKey(ip, configProperty);
        String defaultValue = configProperty.defaultValue();
        if (annotated.getBaseType() instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)annotated.getBaseType();
            Type rawType = paramType.getRawType();
            if (rawType instanceof Class && ((Class)rawType).isAssignableFrom(Provider.class) && paramType.getActualTypeArguments().length == 1) {
                Class clazz = (Class)paramType.getActualTypeArguments()[0];
                return (T)new ConfigValueProvider(this.getConfig(), key, clazz);
            }
        } else {
            Class clazz = (Class)annotated.getBaseType();
            if (defaultValue == null || defaultValue.length() == 0) {
                Object value = this.getConfig().getValue(key, clazz);
                return (T)this.getConfig().getValue(key, clazz);
            }
            Config config = this.getConfig();
            Object value = config.getOptionalValue(key, clazz).orElse(((WildFlyConfig)config).convert(defaultValue, clazz));
            return value;
        }
        throw new IllegalStateException("unhandled ConfigProperty");
    }

    public Config getConfig() {
        if (this._config == null) {
            this._config = ConfigProvider.getConfig();
        }
        return this._config;
    }

    public void destroy(T instance, CreationalContext<T> context) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.clazz);
    }

    public Set<Annotation> getQualifiers() {
        return QUALIFIERS;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return "ConfigInjectionBean_" + this.clazz;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.EMPTY_SET;
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return "ConfigInjectionBean_" + this.clazz;
    }

    static {
        QUALIFIERS.add((Annotation)((Object)new ConfigPropertyLiteral()));
    }

    public static class ConfigValueProvider<T>
    implements Provider<T>,
    Serializable {
        private transient Config config;
        private final String key;
        private final Class<T> type;

        ConfigValueProvider(Config config, String key, Class<T> type) {
            this.config = config;
            this.key = key;
            this.type = type;
        }

        public T get() {
            return (T)this.config.getValue(this.key, this.type);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.config = ConfigProviderResolver.instance().getConfig();
        }
    }

    private static class ConfigPropertyLiteral
    extends AnnotationLiteral<ConfigProperty>
    implements ConfigProperty {
        private ConfigPropertyLiteral() {
        }

        public String name() {
            return "";
        }

        public String defaultValue() {
            return "";
        }
    }
}

