/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health.deployment;

import javax.enterprise.inject.spi.Extension;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.wildfly.extension.microprofile.health.MicroProfileHealthReporter;
import org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition;
import org.wildfly.extension.microprofile.health._private.MicroProfileHealthLogger;
import org.wildfly.extension.microprofile.health.deployment.CDIExtension;

public class DeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        WeldCapability weldCapability;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        try {
            weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw MicroProfileHealthLogger.LOGGER.deploymentRequiresCapability(deploymentUnit.getName(), "org.wildfly.weld");
        }
        if (weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
            MicroProfileHealthReporter healthReporter = (MicroProfileHealthReporter)phaseContext.getServiceRegistry().getService(MicroProfileHealthSubsystemDefinition.HEALTH_REPORTER_SERVICE).getValue();
            weldCapability.registerExtensionInstance((Extension)new CDIExtension(healthReporter, module), deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

