/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsExtension;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsSubsystemDefinition;

public class MetricsTransformers
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "microprofile-metrics-smallrye";
    }

    public void registerTransformers(SubsystemTransformerRegistration subsystemTransformerRegistration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)subsystemTransformerRegistration.getCurrentSubsystemVersion());
        this.registerTransformers_EAP_7_2_0(chainedBuilder.createBuilder(subsystemTransformerRegistration.getCurrentSubsystemVersion(), MicroProfileMetricsExtension.VERSION_1_0_0));
        chainedBuilder.buildAndRegister(subsystemTransformerRegistration, (ModelVersion[][])new ModelVersion[][]{{MicroProfileMetricsExtension.VERSION_1_0_0}});
    }

    private void registerTransformers_EAP_7_2_0(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder subsystem = builder.addChildResource(MicroProfileMetricsExtension.SUBSYSTEM_PATH);
        MetricsTransformers.rejectDefinedAttributeWithDefaultValue(subsystem, MicroProfileMetricsSubsystemDefinition.PREFIX);
    }

    private static void rejectDefinedAttributeWithDefaultValue(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        for (AttributeDefinition attr : attrs) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{attr.getDefaultValue()}), new AttributeDefinition[]{attr})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{attr});
        }
    }
}

