/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.smallrye.metrics.setup.JmxRegistrar;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.microprofile.metrics.MetricCollector;
import org.wildfly.extension.microprofile.metrics.MetricsCollectorService;
import org.wildfly.extension.microprofile.metrics.MetricsContextService;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsSubsystemDefinition;
import org.wildfly.extension.microprofile.metrics._private.MicroProfileMetricsLogger;
import org.wildfly.extension.microprofile.metrics.deployment.DependencyProcessor;
import org.wildfly.extension.microprofile.metrics.deployment.DeploymentMetricProcessor;

class MicroProfileMetricsSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final MicroProfileMetricsSubsystemAdd INSTANCE = new MicroProfileMetricsSubsystemAdd();

    MicroProfileMetricsSubsystemAdd() {
        super(MicroProfileMetricsSubsystemDefinition.ATTRIBUTES);
    }

    protected void performBoottime(final OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performBoottime(context, operation, model);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("microprofile-metrics-smallrye", Phase.DEPENDENCIES, 6240, (DeploymentUnitProcessor)new DependencyProcessor());
                processorTarget.addDeploymentProcessor("microprofile-metrics-smallrye", Phase.INSTALL, 14176, (DeploymentUnitProcessor)new DeploymentMetricProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        boolean securityEnabled = MicroProfileMetricsSubsystemDefinition.SECURITY_ENABLED.resolveModelAttribute(context, model).asBoolean();
        List exposedSubsystems = MicroProfileMetricsSubsystemDefinition.EXPOSED_SUBSYSTEMS.unwrap((ExpressionResolver)context, model);
        String prefix = MicroProfileMetricsSubsystemDefinition.PREFIX.resolveModelAttribute(context, model).asStringOrNull();
        MetricsContextService.install(context, securityEnabled);
        MetricsCollectorService.install(context, exposedSubsystems, prefix);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext operationContext, ModelNode modelNode) {
                ServiceController serviceController = context.getServiceRegistry(false).getService(MicroProfileMetricsSubsystemDefinition.WILDFLY_COLLECTOR_SERVICE);
                MetricCollector metricCollector = (MetricCollector)MetricCollector.class.cast(serviceController.getValue());
                ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
                Resource rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
                metricCollector.collectResourceMetrics(rootResource, rootResourceRegistration, Function.identity());
                JmxRegistrar jmxRegistrar = new JmxRegistrar();
                try {
                    jmxRegistrar.init();
                }
                catch (IOException e) {
                    throw MicroProfileMetricsLogger.LOGGER.failedInitializeJMXRegistrar(e);
                }
            }
        }, OperationContext.Stage.VERIFY);
        MicroProfileMetricsLogger.LOGGER.activatingSubsystem();
    }
}

