/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.ModelOnlyResourceDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsExtension;
import org.wildfly.extension.microprofile.metrics.MigrateOperation;

public class MicroProfileMetricsSubsystemDefinition
extends ModelOnlyResourceDefinition {
    static final String MP_CONFIG = "org.wildfly.microprofile.config";
    public static final ServiceName WILDFLY_COLLECTOR = ServiceName.parse((String)"org.wildfly.extension.metrics.wildfly-collector");
    static final String METRICS_HTTP_CONTEXT_CAPABILITY = "org.wildfly.extension.metrics.http-context";
    static final RuntimeCapability<Void> MICROPROFILE_METRICS_HTTP_SECURITY_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.metrics.http-context.security-enabled", Boolean.class).build();
    static final RuntimeCapability<Void> MICROPROFILE_METRICS_SCAN = RuntimeCapability.Builder.of((String)"org.wildfly.extension.metrics.scan").addRequirements(new String[]{"org.wildfly.extension.metrics.http-context", "org.wildfly.microprofile.config"}).build();
    static final AttributeDefinition SECURITY_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(ModelNode.TRUE)).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).build();
    static final StringListAttributeDefinition EXPOSED_SUBSYSTEMS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("exposed-subsystems").setRequired(false)).setRestartAllServices()).build();
    static final AttributeDefinition PREFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"prefix", (ModelType)ModelType.STRING).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SECURITY_ENABLED, EXPOSED_SUBSYSTEMS, PREFIX};

    protected MicroProfileMetricsSubsystemDefinition() {
        super(new SimpleResourceDefinition.Parameters(MicroProfileMetricsExtension.SUBSYSTEM_PATH, MicroProfileMetricsExtension.getResourceDescriptionResolver("microprofile-metrics-smallrye")).setAddHandler((OperationStepHandler)new ModelOnlyAddStepHandler(ATTRIBUTES)).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler()).setCapabilities(new RuntimeCapability[]{MICROPROFILE_METRICS_HTTP_SECURITY_CAPABILITY, MICROPROFILE_METRICS_SCAN}), new AttributeDefinition[0]);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition att : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(att, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(ATTRIBUTES));
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        MigrateOperation.registerOperations(resourceRegistration, this.getResourceDescriptionResolver());
    }
}

