/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.resteasy.util.AcceptParser;

public class OpenAPIHttpHandler
implements HttpHandler {
    private static final String ALLOW_METHODS = String.join((CharSequence)",", "GET", "HEAD", "OPTIONS");
    private static final String DEFAULT_ALLOW_HEADERS = String.join((CharSequence)",", "Content-Type", "Authorization");
    private static final long DEFAULT_MAX_AGE = ChronoUnit.DAYS.getDuration().getSeconds();
    private static final Map<MediaType, OpenApiSerializer.Format> ACCEPTED_TYPES = new LinkedHashMap<MediaType, OpenApiSerializer.Format>();
    private static final Map<String, OpenApiSerializer.Format> FORMATS = new HashMap<String, OpenApiSerializer.Format>();
    private static final String FORMAT = "format";
    private final OpenAPI model;

    public OpenAPIHttpHandler(OpenAPI model) {
        this.model = model;
    }

    public void handleRequest(HttpServerExchange exchange) throws IOException {
        HttpString requestMethod = exchange.getRequestMethod();
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        responseHeaders.put(new HttpString("Access-Control-Allow-Origin"), "*");
        responseHeaders.put(new HttpString("Access-Control-Allow-Credentials"), "true");
        responseHeaders.put(new HttpString("Access-Control-Allow-Methods"), ALLOW_METHODS);
        responseHeaders.put(new HttpString("Access-Control-Allow-Headers"), DEFAULT_ALLOW_HEADERS);
        responseHeaders.put(new HttpString("Access-Control-Max-Age"), DEFAULT_MAX_AGE);
        if (requestMethod.equals(Methods.GET) || requestMethod.equals(Methods.HEAD)) {
            List preferredTypes = Collections.emptyList();
            List<MediaType> types = OpenAPIHttpHandler.parseAcceptedTypes(exchange);
            for (MediaType type : types) {
                ArrayList compatibleTypes = new ArrayList(ACCEPTED_TYPES.size());
                for (MediaType acceptedType : ACCEPTED_TYPES.keySet()) {
                    if (!type.isCompatible(acceptedType)) continue;
                    compatibleTypes.add(acceptedType);
                }
                if (compatibleTypes.isEmpty()) break;
                preferredTypes = compatibleTypes;
            }
            Charset charset = OpenAPIHttpHandler.parseCharset(exchange);
            if (preferredTypes.isEmpty() || charset == null) {
                exchange.setStatusCode(406);
                return;
            }
            OpenApiSerializer.Format format = preferredTypes.size() == 1 ? ACCEPTED_TYPES.get(preferredTypes.get(0)) : OpenAPIHttpHandler.parseFormatParameter(exchange);
            String result = OpenApiSerializer.serialize((OpenAPI)this.model, (OpenApiSerializer.Format)format);
            responseHeaders.put(Headers.CONTENT_TYPE, format.getMimeType());
            responseHeaders.put(Headers.CONTENT_LENGTH, (long)result.length());
            if (requestMethod.equals(Methods.GET)) {
                exchange.getResponseSender().send(result, charset);
            }
        } else if (requestMethod.equals(Methods.OPTIONS)) {
            responseHeaders.put(Headers.ALLOW, ALLOW_METHODS);
        } else {
            exchange.setStatusCode(405);
        }
    }

    private static List<MediaType> parseAcceptedTypes(HttpServerExchange exchange) {
        String headerValue = exchange.getRequestHeaders().getFirst(Headers.ACCEPT);
        if (headerValue == null) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        List values = AcceptParser.parseAcceptHeader((String)headerValue);
        ArrayList<MediaType> types = new ArrayList<MediaType>(values.size());
        for (String value : values) {
            types.add(MediaType.valueOf((String)value));
        }
        return types;
    }

    private static Charset parseCharset(HttpServerExchange exchange) {
        String headerValue = exchange.getRequestHeaders().getFirst(Headers.ACCEPT_CHARSET);
        if (headerValue == null) {
            return StandardCharsets.UTF_8;
        }
        List values = AcceptParser.parseAcceptHeader((String)headerValue);
        Charset defaultCharset = null;
        for (String value : values) {
            if (value.equals("*")) {
                defaultCharset = StandardCharsets.UTF_8;
            }
            if (!Charset.isSupported(value)) continue;
            return Charset.forName(value);
        }
        return defaultCharset;
    }

    private static OpenApiSerializer.Format parseFormatParameter(HttpServerExchange exchange) {
        Deque formatValues = (Deque)exchange.getQueryParameters().get(FORMAT);
        String formatValue = formatValues != null ? (String)formatValues.peek() : null;
        OpenApiSerializer.Format format = formatValue != null ? FORMATS.get(formatValue) : null;
        return format != null ? format : OpenApiSerializer.Format.YAML;
    }

    static {
        for (OpenApiSerializer.Format format : EnumSet.allOf(OpenApiSerializer.Format.class)) {
            ACCEPTED_TYPES.put(MediaType.valueOf((String)format.getMimeType()), format);
            FORMATS.put(format.name(), format);
        }
    }
}

