/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

public class TracingDependencyProcessor
implements DeploymentUnitProcessor {
    private static final String[] MODULES = new String[]{"io.jaegertracing.jaeger", "io.opentracing.contrib.opentracing-tracerresolver", "io.opentracing.opentracing-api", "io.opentracing.opentracing-util", "org.eclipse.microprofile.opentracing"};
    private static final String[] EXPORTED_MODULES = new String[]{"io.smallrye.opentracing", "org.wildfly.microprofile.opentracing-smallrye"};

    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        this.addDependencies(deploymentUnit);
    }

    private void addDependencies(DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (String module : MODULES) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, module, false, false, true, false));
        }
        for (String module : EXPORTED_MODULES) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, module, false, true, true, false));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

