/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing.resolver;

import io.jaegertracing.Configuration;
import io.opentracing.Tracer;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.microprofile.opentracing.JaegerTracerConfigurationDefinition;
import org.wildfly.extension.microprofile.opentracing.SubsystemDefinition;
import org.wildfly.extension.microprofile.opentracing.TracerAttributes;
import org.wildfly.microprofile.opentracing.smallrye.TracerConfiguration;

public class JaegerTracerConfiguration
implements TracerConfiguration {
    private final Configuration.CodecConfiguration codecConfig;
    private final Configuration.SamplerConfiguration samplerConfig;
    private final Configuration.ReporterConfiguration reporterConfig;
    private final boolean traceId128Bit;
    private final Map<String, String> tracerTags;
    private final ModelNode model;
    private final String name;

    public JaegerTracerConfiguration(OperationContext context, ModelNode configuration, Supplier<OutboundSocketBinding> outboundSocketBindingSupplier) throws OperationFailedException {
        this.name = SubsystemDefinition.TRACER_CAPABILITY.getCapabilityServiceName(new String[]{context.getCurrentAddressValue()}).getCanonicalName();
        this.model = new ModelNode();
        for (AttributeDefinition att : JaegerTracerConfigurationDefinition.ATTRIBUTES) {
            ModelNode value = att.resolveModelAttribute(context, configuration);
            if (!value.isDefined()) continue;
            this.model.get(att.getName()).set(value);
        }
        this.model.protect();
        this.codecConfig = new Configuration.CodecConfiguration();
        for (String codec : TracerAttributes.PROPAGATION.unwrap((ExpressionResolver)context, configuration)) {
            this.codecConfig.withPropagation(Configuration.Propagation.valueOf((String)codec));
        }
        this.samplerConfig = new Configuration.SamplerConfiguration().withType(TracerAttributes.SAMPLER_TYPE.resolveModelAttribute(context, configuration).asStringOrNull()).withParam((Number)TracerAttributes.SAMPLER_PARAM.resolveModelAttribute(context, configuration).asDoubleOrNull()).withManagerHostPort(TracerAttributes.SAMPLER_MANAGER_HOST_PORT.resolveModelAttribute(context, configuration).asStringOrNull());
        Configuration.SenderConfiguration senderConfiguration = new Configuration.SenderConfiguration().withAuthPassword(TracerAttributes.SENDER_AUTH_PASSWORD.resolveModelAttribute(context, configuration).asStringOrNull()).withAuthUsername(TracerAttributes.SENDER_AUTH_USER.resolveModelAttribute(context, configuration).asStringOrNull()).withAuthToken(TracerAttributes.SENDER_AUTH_TOKEN.resolveModelAttribute(context, configuration).asStringOrNull()).withEndpoint(TracerAttributes.SENDER_ENDPOINT.resolveModelAttribute(context, configuration).asStringOrNull());
        if (outboundSocketBindingSupplier.get() != null) {
            senderConfiguration.withAgentHost(outboundSocketBindingSupplier.get().getUnresolvedDestinationAddress()).withAgentPort(Integer.valueOf(outboundSocketBindingSupplier.get().getDestinationPort()));
        }
        this.reporterConfig = new Configuration.ReporterConfiguration().withSender(senderConfiguration).withFlushInterval(TracerAttributes.REPORTER_FLUSH_INTERVAL.resolveModelAttribute(context, configuration).asIntOrNull()).withLogSpans(TracerAttributes.REPORTER_LOG_SPANS.resolveModelAttribute(context, configuration).asBooleanOrNull()).withMaxQueueSize(TracerAttributes.REPORTER_MAX_QUEUE_SIZE.resolveModelAttribute(context, configuration).asIntOrNull());
        this.tracerTags = TracerAttributes.TRACER_TAGS.unwrap((ExpressionResolver)context, configuration);
        this.traceId128Bit = TracerAttributes.TRACEID_128BIT.resolveModelAttribute(context, configuration).asBoolean();
    }

    public String getName() {
        return this.name;
    }

    public Tracer createTracer(String serviceName) {
        return new Configuration(serviceName).withCodec(this.codecConfig).withReporter(this.reporterConfig).withSampler(this.samplerConfig).withTraceId128Bit(this.traceId128Bit).withTracerTags(this.tracerTags).getTracerBuilder().withManualShutdown().build();
    }

    public String getModuleName() {
        return "io.jaegertracing.jaeger";
    }

    public ModelNode getModel() {
        return this.model;
    }
}

