package org.wildfly.extension.microprofile.opentracing;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-03-10T13:47:12-0800")
public class TracingExtensionLogger_$logger extends DelegatingBasicLogger implements TracingExtensionLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = TracingExtensionLogger_$logger.class.getName();
    public TracingExtensionLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str());
    }
    protected String activatingSubsystem$str() {
        return "WFLYTRACEXT0001: Activating MicroProfile OpenTracing Subsystem";
    }
    @Override
    public final void processingDeployment() {
        super.log.logf(FQCN, DEBUG, null, processingDeployment$str());
    }
    protected String processingDeployment$str() {
        return "WFLYTRACEXT0002: MicroProfile OpenTracing Subsystem is processing deployment";
    }
    @Override
    public final void noCdiDeployment() {
        super.log.logf(FQCN, DEBUG, null, noCdiDeployment$str());
    }
    protected String noCdiDeployment$str() {
        return "WFLYTRACEXT0003: The deployment does not have Jakarta Contexts and Dependency Injection enabled. Skipping MicroProfile OpenTracing integration.";
    }
    @Override
    public final void serviceNameDerivedFromDeploymentUnit(final String serviceName) {
        super.log.logf(FQCN, DEBUG, null, serviceNameDerivedFromDeploymentUnit$str(), serviceName);
    }
    protected String serviceNameDerivedFromDeploymentUnit$str() {
        return "WFLYTRACEXT0004: Deriving service name based on the deployment unit's name: %s";
    }
    @Override
    public final void registeringTracerInitializer() {
        super.log.logf(FQCN, DEBUG, null, registeringTracerInitializer$str());
    }
    protected String registeringTracerInitializer$str() {
        return "WFLYTRACEXT0005: Registering the TracerInitializer filter";
    }
    protected String deploymentRequiresCapability$str() {
        return "WFLYTRACEXT0006: Deployment %s requires use of the '%s' capability but it is not currently registered";
    }
    @Override
    public final String deploymentRequiresCapability(final String deploymentName, final String capabilityName) {
        return String.format(getLoggingLocale(), deploymentRequiresCapability$str(), deploymentName, capabilityName);
    }
    @Override
    public final void tracerResolverDeployementModuleNotFound(final String deployment) {
        super.log.logf(FQCN, DEBUG, null, tracerResolverDeployementModuleNotFound$str(), deployment);
    }
    protected String tracerResolverDeployementModuleNotFound$str() {
        return "WFLYTRACEXT0007: No module found for deployment %s for resolving the tracer.";
    }
    @Override
    public final void errorResolvingTracer(final Exception ex) {
        super.log.logf(FQCN, ERROR, ex, errorResolvingTracer$str());
    }
    protected String errorResolvingTracer$str() {
        return "WFLYTRACEXT0008: Error using tracer resolver to resolve the tracer.";
    }
}
