/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.MultistepUtil;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.microprofile.opentracing.TracingExtensionLogger;

public class MigrateOperation
implements OperationStepHandler {
    private static final String OPENTELEMETRY_EXTENSION = "org.wildfly.extension.opentelemetry";
    private static final PathAddress OPENTRACING_EXTENSION_ELEMENT = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension", (String)"org.wildfly.extension.microprofile.opentracing-smallrye")});
    private static final PathAddress OPENTRACING_SUBSYSTEM_ELEMENT = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"microprofile-opentracing-smallrye")});
    private static final PathElement OPENTELEMETRY_EXTENSION_ELEMENT = PathElement.pathElement((String)"extension", (String)"org.wildfly.extension.opentelemetry");
    private static final PathElement OPENTELEMETRY_SUBSYSTEM_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"opentelemetry");
    private static final String MIGRATE = "migrate";
    private static final String MIGRATION_WARNINGS = "migration-warnings";
    private static final String MIGRATION_ERROR = "migration-error";
    private static final String MIGRATION_OPERATIONS = "migration-operations";
    private static final String DESCRIBE_MIGRATION = "describe-migration";
    static final StringListAttributeDefinition MIGRATION_WARNINGS_ATTR = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("migration-warnings").setRequired(false)).build();
    static final SimpleMapAttributeDefinition MIGRATION_ERROR_ATTR = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("migration-error", ModelType.OBJECT, true).setValueType(ModelType.OBJECT).setRequired(false)).build();
    private final boolean describe;

    private MigrateOperation(boolean describe) {
        this.describe = describe;
    }

    static void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(MIGRATE, resourceDescriptionResolver).setReplyParameters(new AttributeDefinition[]{MIGRATION_WARNINGS_ATTR, MIGRATION_ERROR_ATTR}).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).build(), (OperationStepHandler)new MigrateOperation(false));
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(DESCRIBE_MIGRATION, resourceDescriptionResolver).setReplyParameters(new AttributeDefinition[]{MIGRATION_WARNINGS_ATTR, MIGRATION_ERROR_ATTR}).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).setReadOnly().build(), (OperationStepHandler)new MigrateOperation(true));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!this.describe && context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw TracingExtensionLogger.ROOT_LOGGER.migrateOperationAllowedOnlyInAdminOnly();
        }
        PathAddress subsystemsAddress = context.getCurrentAddress().getParent();
        LinkedHashMap<PathAddress, ModelNode> migrateOperations = new LinkedHashMap<PathAddress, ModelNode>();
        if (!context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false).hasChild(OPENTELEMETRY_EXTENSION_ELEMENT)) {
            this.addOpenTelemetryExtension(context, migrateOperations);
        }
        context.addStep((operationContext, modelNode) -> {
            this.addOpenTelemetrySubsystem(context, migrateOperations);
            PathAddress opentracingAddress = subsystemsAddress.append(OPENTRACING_SUBSYSTEM_ELEMENT);
            this.removeOpentracingSubsystem(opentracingAddress, migrateOperations, context.getProcessType() == ProcessType.STANDALONE_SERVER);
            if (this.describe) {
                Collection values = migrateOperations.values();
                ModelNode result = new ModelNode();
                result.get(MIGRATION_OPERATIONS).set(values);
                result.get(MIGRATION_WARNINGS).set(new ModelNode().setEmptyList());
                context.getResult().set(result);
            } else {
                Map<PathAddress, ModelNode> migrateOpResponses = this.migrateSubsystems(context, migrateOperations);
                context.completeStep((resultAction, context1, operation1) -> {
                    ModelNode result = new ModelNode();
                    result.get(MIGRATION_WARNINGS).set(new ModelNode().setEmptyList());
                    if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                        for (Map.Entry entry : migrateOpResponses.entrySet()) {
                            if (!((ModelNode)entry.getValue()).hasDefined("failure-description")) continue;
                            ModelNode desc = new ModelNode();
                            desc.get("operation").set((ModelNode)migrateOperations.get(entry.getKey()));
                            desc.get("result").set((ModelNode)entry.getValue());
                            result.get(MIGRATION_ERROR).set(desc);
                            break;
                        }
                        context1.getFailureDescription().set(new ModelNode(TracingExtensionLogger.ROOT_LOGGER.migrationFailed()));
                    }
                    context1.getResult().set(result);
                });
            }
        }, OperationContext.Stage.MODEL);
    }

    private void addOpenTelemetryExtension(OperationContext context, Map<PathAddress, ModelNode> migrateOperations) {
        PathAddress extensionAddress = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{OPENTELEMETRY_EXTENSION_ELEMENT});
        OperationEntry addEntry = context.getRootResourceRegistration().getOperationEntry(extensionAddress, "add");
        ModelNode addOperation = Util.createAddOperation((PathAddress)extensionAddress);
        if (this.describe) {
            migrateOperations.put(extensionAddress, addOperation);
        } else {
            context.addStep(context.getResult().get(extensionAddress.toString()), addOperation, addEntry.getOperationHandler(), OperationContext.Stage.MODEL);
        }
    }

    private void addOpenTelemetrySubsystem(OperationContext context, Map<PathAddress, ModelNode> migrateOperations) {
        PathAddress parentAddress = context.getCurrentAddress().getParent();
        Resource root = context.readResourceFromRoot(parentAddress, false);
        if (root.hasChild(OPENTELEMETRY_SUBSYSTEM_ELEMENT)) {
            return;
        }
        PathAddress subsystemAddress = parentAddress.append(new PathElement[]{OPENTELEMETRY_SUBSYSTEM_ELEMENT});
        ModelNode operation = Util.createAddOperation((PathAddress)subsystemAddress);
        migrateOperations.put(subsystemAddress, operation);
    }

    private void removeOpentracingSubsystem(PathAddress address, Map<PathAddress, ModelNode> migrateOperations, boolean standalone) {
        ModelNode removeLegacySubsystemOperation = Util.createRemoveOperation((PathAddress)address);
        migrateOperations.put(address, removeLegacySubsystemOperation);
        if (standalone) {
            removeLegacySubsystemOperation = Util.createRemoveOperation((PathAddress)OPENTRACING_EXTENSION_ELEMENT);
            migrateOperations.put(OPENTRACING_EXTENSION_ELEMENT, removeLegacySubsystemOperation);
        }
    }

    private Map<PathAddress, ModelNode> migrateSubsystems(OperationContext context, Map<PathAddress, ModelNode> migrationOperations) throws OperationFailedException {
        LinkedHashMap<PathAddress, ModelNode> result = new LinkedHashMap<PathAddress, ModelNode>();
        MultistepUtil.recordOperationSteps((OperationContext)context, migrationOperations, result);
        return result;
    }
}

