/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.telemetry;

import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import jakarta.enterprise.inject.spi.Extension;
import java.util.HashMap;
import java.util.function.Supplier;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.wildfly.extension.microprofile.telemetry.MicroProfileTelemetryExtensionLogger;
import org.wildfly.extension.microprofile.telemetry.api.MicroProfileTelemetryCdiExtension;

public class MicroProfileTelemetryDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        try {
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            WeldCapability weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
            if (weldCapability != null && !weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
                MicroProfileTelemetryExtensionLogger.MPTEL_LOGGER.debug("The deployment does not have Jakarta Contexts and Dependency Injection enabled. Skipping MicroProfile Telemetry integration.");
            } else {
                OpenTelemetryConfig serverConfig = (OpenTelemetryConfig)((Supplier)support.getCapabilityRuntimeAPI("org.wildfly.extension.opentelemetry.config", Supplier.class)).get();
                HashMap<String, String> properties = new HashMap<String, String>(serverConfig.properties());
                if (!properties.containsKey("otel.service.name")) {
                    properties.put("otel.service.name", this.getServiceName(deploymentUnit));
                }
                weldCapability.registerExtensionInstance((Extension)new MicroProfileTelemetryCdiExtension(properties), deploymentUnit);
            }
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw MicroProfileTelemetryExtensionLogger.MPTEL_LOGGER.deploymentRequiresCapability(deploymentPhaseContext.getDeploymentUnit().getName(), "org.wildfly.weld");
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private String getServiceName(DeploymentUnit deploymentUnit) {
        Object serviceName = deploymentUnit.getServiceName().getSimpleName();
        if (null != deploymentUnit.getParent()) {
            serviceName = deploymentUnit.getParent().getServiceName().getSimpleName() + "!" + (String)serviceName;
        }
        return serviceName;
    }
}

