package org.wildfly.extension.mod_cluster;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-11-02T15:11:44+0000")
public class ModClusterLogger_$logger extends DelegatingBasicLogger implements ModClusterLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ModClusterLogger_$logger.class.getName();
    public ModClusterLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void errorAddingMetrics(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorAddingMetrics$str());
    }
    protected String errorAddingMetrics$str() {
        return "WFLYMODCLS0001: Error adding metrics.";
    }
    @Override
    public final void multicastInterfaceNotAvailable() {
        super.log.logf(FQCN, ERROR, null, multicastInterfaceNotAvailable$str());
    }
    protected String multicastInterfaceNotAvailable$str() {
        return "WFLYMODCLS0004: Mod_cluster requires Advertise but Multicast interface is not available";
    }
    @Override
    public final void usingSimpleLoadProvider(final String proxyName) {
        super.log.logf(FQCN, WARN, null, usingSimpleLoadProvider$str(), proxyName);
    }
    protected String usingSimpleLoadProvider$str() {
        return "WFLYMODCLS0005: No mod_cluster load balance factor provider specified for proxy '%s'! Using load balance factor provider with constant factor of '1'.";
    }
    @Override
    public final void errorApplyingMetricProperties(final Throwable cause, final String metricClass) {
        super.log.logf(FQCN, ERROR, cause, errorApplyingMetricProperties$str(), metricClass);
    }
    protected String errorApplyingMetricProperties$str() {
        return "WFLYMODCLS0006: Error applying properties to load metric class '%s'. Metric will not be loaded.";
    }
    @Override
    public final void unsupportedMetric(final String metricType) {
        super.log.logf(FQCN, WARN, null, unsupportedMetric$str(), metricType);
    }
    protected String unsupportedMetric$str() {
        return "WFLYMODCLS0007: Metric of type '%s' is no longer supported and will be ignored.";
    }
    protected String contextOrHostNotFound$str() {
        return "WFLYMODCLS0011: Virtual host '%s' or context '%s' not found.";
    }
    @Override
    public final String contextOrHostNotFound(final String host, final String context) {
        return String.format(getLoggingLocale(), contextOrHostNotFound$str(), host, context);
    }
    protected String needHostAndPort$str() {
        return "WFLYMODCLS0014: Need valid host and port in the form host:port, %s is not valid";
    }
    @Override
    public final String needHostAndPort(final String value) {
        return String.format(getLoggingLocale(), needHostAndPort$str(), value);
    }
    protected String couldNotResolveProxyIpAddress$str() {
        return "WFLYMODCLS0016: No IP address could be resolved for the specified host of the proxy.";
    }
    @Override
    public final String couldNotResolveProxyIpAddress() {
        return String.format(getLoggingLocale(), couldNotResolveProxyIpAddress$str());
    }
    protected String excludedContextsWrongFormat$str() {
        return "WFLYMODCLS0019: '%s' is not a valid value for excluded-contexts.";
    }
    @Override
    public final IllegalArgumentException excludedContextsWrongFormat(final String trimmedContexts) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), excludedContextsWrongFormat$str(), trimmedContexts));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String bothElytronAndLegacySslContextDefined$str() {
        return "WFLYMODCLS0020: Only one of 'ssl-context' attribute or 'ssl' resource can be defined!";
    }
    @Override
    public final IllegalStateException bothElytronAndLegacySslContextDefined() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), bothElytronAndLegacySslContextDefined$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void excludedContextsUseSlashInsteadROOT() {
        super.log.logf(FQCN, WARN, null, excludedContextsUseSlashInsteadROOT$str());
    }
    protected String excludedContextsUseSlashInsteadROOT$str() {
        return "WFLYMODCLS0021: Value 'ROOT' for excluded-contexts is deprecated, to exclude the root context use '/' instead.";
    }
    protected String legacyOperationsWithMultipleProxies$str() {
        return "WFLYMODCLS0022: Legacy operations cannot be used with multiple proxy configurations. Use non-deprecated operations at the correct proxy address.";
    }
    @Override
    public final String legacyOperationsWithMultipleProxies() {
        return String.format(getLoggingLocale(), legacyOperationsWithMultipleProxies$str());
    }
    @Override
    public final void errorLoadingModuleForCustomMetric(final String moduleName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorLoadingModuleForCustomMetric$str(), moduleName);
    }
    protected String errorLoadingModuleForCustomMetric$str() {
        return "WFLYMODCLS0023: Error loading module '%s' to load custom metric from.";
    }
    protected String simpleLoadFactorProviderIsNotConfigured$str() {
        return "WFLYMODCLS0024: Dynamic load factor provider is currently configured. A simple load factor provider needs to be configured first to read or write a static factor.";
    }
    @Override
    public final OperationFailedException simpleLoadFactorProviderIsNotConfigured() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), simpleLoadFactorProviderIsNotConfigured$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
