package org.wildfly.extension.mod_cluster;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-12-16T00:08:52+0100")
public class ModClusterLogger_$logger extends DelegatingBasicLogger implements ModClusterLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ModClusterLogger_$logger.class.getName();
    public ModClusterLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void errorAddingMetrics(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorAddingMetrics$str());
    }
    protected String errorAddingMetrics$str() {
        return "WFLYMODCLS0001: Error adding metrics.";
    }
    @Override
    public final void multicastInterfaceNotAvailable() {
        super.log.logf(FQCN, ERROR, null, multicastInterfaceNotAvailable$str());
    }
    protected String multicastInterfaceNotAvailable$str() {
        return "WFLYMODCLS0004: Mod_cluster requires Advertise but Multicast interface is not available.";
    }
    @Override
    public final void usingSimpleLoadProvider(final String proxyName) {
        super.log.logf(FQCN, WARN, null, usingSimpleLoadProvider$str(), proxyName);
    }
    protected String usingSimpleLoadProvider$str() {
        return "WFLYMODCLS0005: No mod_cluster load balance factor provider specified for proxy '%s'! Using load balance factor provider with constant factor of '1'.";
    }
    @Override
    public final void errorApplyingMetricProperties(final Throwable cause, final String metricClass) {
        super.log.logf(FQCN, ERROR, cause, errorApplyingMetricProperties$str(), metricClass);
    }
    protected String errorApplyingMetricProperties$str() {
        return "WFLYMODCLS0006: Error applying properties to load metric class '%s'. Metric will not be loaded.";
    }
    protected String contextOrHostNotFound$str() {
        return "WFLYMODCLS0011: Virtual host '%s' or context '%s' not found.";
    }
    @Override
    public final String contextOrHostNotFound(final String host, final String context) {
        return String.format(getLoggingLocale(), contextOrHostNotFound$str(), host, context);
    }
    protected String excludedContextsWrongFormat$str() {
        return "WFLYMODCLS0019: '%s' is not a valid value for excluded-contexts.";
    }
    @Override
    public final IllegalArgumentException excludedContextsWrongFormat(final String trimmedContexts) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), excludedContextsWrongFormat$str(), trimmedContexts));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void excludedContextsUseSlashInsteadROOT() {
        super.log.logf(FQCN, WARN, null, excludedContextsUseSlashInsteadROOT$str());
    }
    protected String excludedContextsUseSlashInsteadROOT$str() {
        return "WFLYMODCLS0021: Value 'ROOT' for excluded-contexts is deprecated, to exclude the root context use '/' instead.";
    }
    @Override
    public final void errorLoadingModuleForCustomMetric(final String moduleName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorLoadingModuleForCustomMetric$str(), moduleName);
    }
    protected String errorLoadingModuleForCustomMetric$str() {
        return "WFLYMODCLS0023: Error loading module '%s' to load custom metric from.";
    }
    @Override
    public final void ignoredElement(final String element) {
        super.log.logf(FQCN, WARN, null, ignoredElement$str(), element);
    }
    protected String ignoredElement$str() {
        return "WFLYMODCLS0025: The '%s' element is no longer supported and will be ignored.";
    }
    @Override
    public final void ignoredAttribute(final String attribute, final String element) {
        super.log.logf(FQCN, WARN, null, ignoredAttribute$str(), attribute, element);
    }
    protected String ignoredAttribute$str() {
        return "WFLYMODCLS0026: Attribute '%s' of element '%s' is no longer supported and will be ignored.";
    }
}
