/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.mod_cluster.LoadMetricDefinition;
import org.wildfly.extension.mod_cluster.ModClusterExtension;

public class ModClusterRemoveMetric
implements OperationStepHandler {
    static final ModClusterRemoveMetric INSTANCE = new ModClusterRemoveMetric();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress parent = PathAddress.pathAddress((PathElement[])new PathElement[]{ModClusterExtension.SUBSYSTEM_PATH, ModClusterExtension.CONFIGURATION_PATH, ModClusterExtension.DYNAMIC_LOAD_PROVIDER_PATH});
        String type = LoadMetricDefinition.TYPE.resolveModelAttribute(context, operation).asString();
        String name = this.getMetricName(context, type);
        if (name == null) {
            context.setRollbackOnly();
        } else {
            ModelNode targetOperation = Util.createRemoveOperation((PathAddress)parent.append(new PathElement[]{PathElement.pathElement((String)ModClusterExtension.LOAD_METRIC_PATH.getKey(), (String)name)}));
            context.addStep(targetOperation, (OperationStepHandler)new ReloadRequiredRemoveStepHandler(), OperationContext.Stage.MODEL, true);
        }
        context.stepCompleted();
    }

    private String getMetricName(OperationContext context, String type) {
        Set metrics = context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{ModClusterExtension.DYNAMIC_LOAD_PROVIDER_PATH})).getChildrenNames("load-metric");
        for (String name : metrics) {
            if (!name.equals(type)) continue;
            return name;
        }
        return null;
    }
}

