/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.common.expression.Expression;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.NamingContextFactory;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.NamingProviderFactory;
import org.wildfly.naming.client.Version;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.naming.client.util.NamingUtils;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.xnio.Options;

public final class WildFlyRootContext
implements Context {
    private static final NameParser NAME_PARSER;
    private final FastHashtable<String, Object> environment;
    private final Object loaderLock = new Object();
    private final ServiceLoader<NamingProviderFactory> namingProviderServiceLoader;
    private final ServiceLoader<NamingContextFactory> namingContextServiceLoader;
    private AuthenticationConfiguration stickyAuthenticationConfiguration;
    private SSLContext stickySslContext;

    public WildFlyRootContext(FastHashtable<String, Object> environment) {
        this(environment, WildFlyRootContext.secureGetContextClassLoader());
    }

    public WildFlyRootContext(FastHashtable<String, Object> environment, ClassLoader classLoader) {
        this.environment = environment;
        this.namingProviderServiceLoader = WildFlyRootContext.secureGetServiceLoader(NamingProviderFactory.class, classLoader);
        this.namingContextServiceLoader = WildFlyRootContext.secureGetServiceLoader(NamingContextFactory.class, classLoader);
    }

    private WildFlyRootContext(FastHashtable<String, Object> environment, ServiceLoader<NamingProviderFactory> namingProviderServiceLoader, ServiceLoader<NamingContextFactory> namingContextServiceLoader) {
        this.environment = environment;
        this.namingProviderServiceLoader = namingProviderServiceLoader;
        this.namingContextServiceLoader = namingContextServiceLoader;
    }

    private static <T> ServiceLoader<T> secureGetServiceLoader(Class<T> factory, ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        ServiceLoader serviceLoader = sm != null ? AccessController.doPrivileged(() -> ServiceLoader.load(factory, classLoader)) : ServiceLoader.load(factory, classLoader);
        return serviceLoader;
    }

    private static ClassLoader secureGetContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader contextClassLoader = sm != null ? AccessController.doPrivileged(WildFlyRootContext::getContextClassLoader) : WildFlyRootContext.getContextClassLoader();
        return contextClassLoader == null ? WildFlyRootContext.class.getClassLoader() : contextClassLoader;
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        if (reparsedName.isEmpty()) {
            return new WildFlyRootContext((FastHashtable<String, Object>)this.environment.clone(), this.namingProviderServiceLoader, this.namingContextServiceLoader);
        }
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.lookup(name);
        }
        return result.context.lookup(reparsedName.getName());
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        if (reparsedName.isEmpty()) {
            return new WildFlyRootContext((FastHashtable<String, Object>)this.environment.clone(), this.namingProviderServiceLoader, this.namingContextServiceLoader);
        }
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.lookup(name);
        }
        return result.context.lookup(reparsedName.getName());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.bind(name, obj);
        } else {
            result.context.bind(reparsedName.getName(), obj);
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.bind(name, obj);
        } else {
            result.context.bind(reparsedName.getName(), obj);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.rebind(name, obj);
        } else {
            result.context.rebind(reparsedName.getName(), obj);
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.rebind(name, obj);
        } else {
            result.context.rebind(reparsedName.getName(), obj);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.unbind(name);
        } else {
            result.context.unbind(reparsedName.getName());
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.unbind(name);
        } else {
            result.context.unbind(reparsedName.getName());
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        Assert.checkNotNullParam((String)"oldName", (Object)oldName);
        Assert.checkNotNullParam((String)"newName", (Object)newName);
        ReparsedName oldReparsedName = this.reparse(this.getNameParser().parse(oldName));
        ReparsedName newReparsedName = this.reparse(this.getNameParser().parse(newName));
        ContextResult result = this.getProviderContext(oldReparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.rename(oldName, newName);
        } else {
            result.context.rename(oldReparsedName.getName(), newReparsedName.getName());
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Assert.checkNotNullParam((String)"oldName", (Object)oldName);
        Assert.checkNotNullParam((String)"newName", (Object)newName);
        ReparsedName oldReparsedName = this.reparse(oldName);
        ReparsedName newReparsedName = this.reparse(newName);
        ContextResult result = this.getProviderContext(oldReparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.rename(oldName, newName);
        } else {
            result.context.rename(oldReparsedName.getName(), newReparsedName.getName());
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.list(name));
        }
        return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.list(reparsedName.getName()));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.list(name));
        }
        return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.list(reparsedName.getName()));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.listBindings(name));
        }
        return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.listBindings(reparsedName.getName()));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.listBindings(name));
        }
        return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext((String)reparsedName.getUrlScheme()).context.listBindings(reparsedName.getName()));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.destroySubcontext(name);
        } else {
            result.context.destroySubcontext(reparsedName.getName());
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            result.context.destroySubcontext(name);
        } else {
            result.context.destroySubcontext(reparsedName.getName());
        }
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.createSubcontext(name);
        }
        return result.context.createSubcontext(reparsedName.getName());
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.createSubcontext(name);
        }
        return result.context.createSubcontext(reparsedName.getName());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(this.getNameParser().parse(name));
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.lookupLink(name);
        }
        return result.context.lookupLink(reparsedName.getName());
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        ContextResult result = this.getProviderContext(reparsedName.getUrlScheme());
        if (result.oldStyle) {
            return result.context.lookupLink(name);
        }
        return result.context.lookupLink(reparsedName.getName());
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser();
    }

    @Override
    public NameParser getNameParser(String s) throws NamingException {
        return this.getNameParser();
    }

    private NameParser getNameParser() {
        return NAME_PARSER;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"prefix", (Object)prefix);
        return this.composeName(this.getNameParser().parse(name), this.getNameParser().parse(prefix)).toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return prefix.addAll(name);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    public FastHashtable<String, Object> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextResult getProviderContext(String nameScheme) throws NamingException {
        ServiceLoader<NamingProviderFactory> providerLoader;
        List<URI> providerUris = this.getProviderUris();
        if (providerUris == null || providerUris.stream().map(URI::getScheme).allMatch(scheme -> scheme == null || scheme.isEmpty())) {
            Context context;
            Object object = this.loaderLock;
            synchronized (object) {
                Iterator<NamingContextFactory> contextIterator = this.namingContextServiceLoader.iterator();
                while (true) {
                    try {
                        while (contextIterator.hasNext()) {
                            NamingContextFactory contextFactory = contextIterator.next();
                            if (!contextFactory.supportsUriScheme(null, nameScheme)) continue;
                            return new ContextResult(contextFactory.createRootContext(null, nameScheme, (FastHashtable<String, Object>)this.getEnvironment()), false);
                        }
                    }
                    catch (ServiceConfigurationError error) {
                        Messages.log.serviceConfigFailed(error);
                        continue;
                    }
                    break;
                }
            }
            if (nameScheme != null && (context = NamingManager.getURLContext(nameScheme, this.environment)) != null) {
                return new ContextResult(context, true);
            }
            return new ContextResult(NamingUtils.emptyContext(this.getEnvironment()), false);
        }
        ServiceLoader<NamingProviderFactory> serviceLoader = providerLoader = this.namingProviderServiceLoader;
        synchronized (serviceLoader) {
            Context context;
            Iterator<NamingProviderFactory> providerIterator = providerLoader.iterator();
            block14: while (true) {
                try {
                    while (providerIterator.hasNext()) {
                        NamingProviderFactory providerFactory = providerIterator.next();
                        boolean supportsUriSchemes = true;
                        for (URI providerUri : providerUris) {
                            if (providerFactory.supportsUriScheme(providerUri.getScheme(), (FastHashtable<String, Object>)this.getEnvironment())) continue;
                            supportsUriSchemes = false;
                            break;
                        }
                        if (!supportsUriSchemes) continue;
                        NamingProvider provider = providerFactory.createProvider((FastHashtable<String, Object>)this.getEnvironment(), providerUris.toArray(new URI[providerUris.size()]));
                        Iterator<NamingContextFactory> contextIterator = this.namingContextServiceLoader.iterator();
                        while (true) {
                            try {
                                NamingContextFactory contextFactory;
                                do {
                                    if (!contextIterator.hasNext()) continue block14;
                                } while (!(contextFactory = contextIterator.next()).supportsUriScheme(provider, nameScheme));
                                return new ContextResult(contextFactory.createRootContext(provider, nameScheme, (FastHashtable<String, Object>)this.getEnvironment()), false);
                            }
                            catch (ServiceConfigurationError error) {
                                Messages.log.serviceConfigFailed(error);
                                continue;
                            }
                            break;
                        }
                    }
                }
                catch (ServiceConfigurationError error) {
                    Messages.log.serviceConfigFailed(error);
                    continue;
                }
                break;
            }
            if (nameScheme != null && (context = NamingManager.getURLContext(nameScheme, this.environment)) != null) {
                return new ContextResult(context, true);
            }
            throw Messages.log.noProviderForUri(nameScheme);
        }
    }

    private List<URI> getProviderUris() throws NamingException {
        String providerUrl;
        Hashtable env = this.getEnvironment();
        Object urlString = ((FastHashtable)env).get("java.naming.provider.url");
        if (urlString != null && !(providerUrl = Expression.compile((String)urlString.toString(), (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX}).evaluateWithPropertiesAndEnvironment(false)).isEmpty()) {
            String[] urls = providerUrl.split(",");
            ArrayList<URI> providerUris = new ArrayList<URI>(urls.length);
            for (String url : urls) {
                URI providerUri;
                try {
                    providerUri = new URI(url.trim());
                }
                catch (URISyntaxException e) {
                    throw Messages.log.invalidProviderUri(e, url);
                }
                providerUris.add(providerUri);
            }
            return providerUris;
        }
        String connectionNameList = ((FastHashtable)env).getOrDefault("remote.connections", "").trim();
        if (!connectionNameList.isEmpty()) {
            Messages.log.deprecatedProperties();
            String[] names = connectionNameList.split("\\s*,\\s*");
            ArrayList<URI> uriList = new ArrayList<URI>(names.length);
            for (String connectionName : names) {
                String protocol;
                connectionName = connectionName.trim();
                String ejbPrefix = "remote.connection." + connectionName + ".";
                String host = this.getStringProperty(ejbPrefix + "host", (FastHashtable<String, Object>)env);
                String port = this.getStringProperty(ejbPrefix + "port", (FastHashtable<String, Object>)env);
                String sslEnabled = this.getStringProperty(ejbPrefix + "connect.options." + Options.SSL_ENABLED, (FastHashtable<String, Object>)env);
                if (sslEnabled == null) {
                    sslEnabled = this.getStringProperty("remote.connectionprovider.create.options." + Options.SSL_ENABLED, (FastHashtable<String, Object>)env);
                }
                if ((protocol = this.getStringProperty(ejbPrefix + "protocol", (FastHashtable<String, Object>)env)) == null) {
                    protocol = Boolean.parseBoolean(sslEnabled) ? "remote+https" : "remote+http";
                }
                if (host == null || port == null) continue;
                String realHost = Expression.compile((String)host, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX}).evaluateWithPropertiesAndEnvironment(false);
                if (realHost.indexOf(58) != -1 && !realHost.startsWith("[") && !realHost.endsWith("]")) {
                    realHost = "[" + realHost + "]";
                }
                try {
                    uriList.add(new URI(protocol, null, realHost, Integer.parseInt(port), null, null, null));
                }
                catch (URISyntaxException e) {
                    throw Messages.log.invalidProviderUri(e, protocol + "://" + realHost + ":" + port);
                }
            }
            return uriList;
        }
        return null;
    }

    private String getStringProperty(String propertyName, FastHashtable<String, Object> env) {
        Object propertyValue = env.get(propertyName);
        return propertyValue == null ? null : (String)propertyValue;
    }

    ReparsedName reparse(Name origName) throws InvalidNameException {
        Name name = (Name)origName.clone();
        if (name.isEmpty()) {
            return new ReparsedName(null, name);
        }
        String first = name.get(0);
        int idx = first.indexOf(58);
        if (idx != -1) {
            String urlScheme = first.substring(0, idx);
            String segment = first.substring(idx + 1);
            name.remove(0);
            if (segment.length() > 0 || origName.size() > 1 && origName.get(1).length() > 0) {
                name.add(0, segment);
            }
            return new ReparsedName(urlScheme.isEmpty() ? null : urlScheme, name);
        }
        return new ReparsedName(null, name);
    }

    static {
        Version.getVersion();
        NAME_PARSER = CompositeName::new;
    }

    private class ContextResult {
        final Context context;
        final boolean oldStyle;

        private ContextResult(Context context, boolean oldStyle) {
            this.context = context;
            this.oldStyle = oldStyle;
        }
    }

    class ReparsedName {
        final String urlScheme;
        final Name name;

        ReparsedName(String urlScheme, Name name) {
            this.urlScheme = urlScheme;
            this.name = name;
        }

        public String getUrlScheme() {
            return this.urlScheme;
        }

        public Name getName() {
            return this.name;
        }

        boolean isEmpty() {
            return this.urlScheme == null && this.name.isEmpty();
        }
    }
}

