/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.net.URI;
import java.util.function.Supplier;
import javax.naming.NamingException;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.NamingCloseable;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.xnio.FinishedIoFuture;
import org.xnio.IoFuture;

public final class RemoteNamingProvider
implements NamingProvider {
    private final Endpoint endpoint;
    private final AuthenticationContext capturedAuthenticationContext;
    private final Supplier<IoFuture<Connection>> connectionFactory;
    private final NamingCloseable closeable;
    private final URI providerUri;

    RemoteNamingProvider(Endpoint endpoint, URI providerUri, AuthenticationContext context, FastHashtable<String, Object> env) {
        this.endpoint = endpoint;
        this.providerUri = providerUri;
        this.capturedAuthenticationContext = context;
        this.connectionFactory = () -> endpoint.getConnection(providerUri);
        this.closeable = NamingCloseable.NULL;
    }

    RemoteNamingProvider(Connection connection, AuthenticationContext context, FastHashtable<String, Object> env) {
        this.endpoint = connection.getEndpoint();
        this.providerUri = connection.getPeerURI();
        this.capturedAuthenticationContext = context;
        this.connectionFactory = () -> new FinishedIoFuture((Object)connection);
        this.closeable = () -> {
            try {
                connection.close();
            }
            catch (IOException e) {
                throw Messages.log.namingProviderCloseFailed(e);
            }
        };
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Connection getConnection() throws IOException {
        return (Connection)this.connectionFactory.get().get();
    }

    public AuthenticationContext getCapturedAuthenticationContext() {
        return this.capturedAuthenticationContext;
    }

    @Override
    public URI getProviderUri() {
        return this.providerUri;
    }

    @Override
    public void close() throws NamingException {
        this.closeable.close();
    }
}

