/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.NamingProviderFactory;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.util.CodePointIterator;
import org.xnio.OptionMap;

public final class RemoteNamingProviderFactory
implements NamingProviderFactory {
    public static final String USE_SEPARATE_CONNECTION = "org.wildfly.naming.client.remote.use-separate-connection";
    static final Attachments.Key<RemoteNamingProvider> PROVIDER_KEY = new Attachments.Key(RemoteNamingProvider.class);
    private static final Attachments.Key<ProviderMap> PROVIDER_MAP_KEY = new Attachments.Key(ProviderMap.class);
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    @Override
    public boolean supportsUriScheme(String providerScheme, FastHashtable<String, Object> env) {
        Endpoint endpoint = this.getEndpoint(env);
        return endpoint != null && endpoint.isValidUriScheme(providerScheme);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public NamingProvider createProvider(URI providerUri, FastHashtable<String, Object> env) throws NamingException {
        endpoint = this.getEndpoint(env);
        callbackClass = this.getStringProperty("jboss.naming.client.security.callback.handler.class", env);
        userName = this.getStringProperty("java.naming.security.principal", env);
        password = this.getStringProperty("java.naming.security.credentials", env);
        passwordBase64 = this.getStringProperty("jboss.naming.client.security.password.base64", env);
        realm = this.getStringProperty("jboss.naming.client.security.realm", env);
        useSeparateConnection = Boolean.parseBoolean(String.valueOf(env.get("org.wildfly.naming.client.remote.use-separate-connection")));
        captured = AuthenticationContext.captureCurrent();
        mergedConfiguration = RemoteNamingProviderFactory.AUTH_CONFIGURATION_CLIENT.getAuthenticationConfiguration(providerUri, captured);
        if (callbackClass != null && (userName != null || password != null)) {
            throw Messages.log.callbackHandlerAndUsernameAndPasswordSpecified();
        }
        if (callbackClass != null) {
            classLoader = RemoteNamingProviderFactory.secureGetContextClassLoader();
            try {
                clazz = Class.forName(callbackClass, true, classLoader);
                callbackHandler = (CallbackHandler)clazz.newInstance();
                if (callbackHandler == null) ** GOTO lbl29
                mergedConfiguration = mergedConfiguration.useCallbackHandler(callbackHandler);
            }
            catch (ClassNotFoundException e) {
                throw Messages.log.failedToLoadCallbackHandlerClass(e, callbackClass);
            }
            catch (Exception e) {
                throw Messages.log.failedToInstantiateCallbackHandlerInstance(e, callbackClass);
            }
        } else if (userName != null) {
            if (password != null && passwordBase64 != null) {
                throw Messages.log.plainTextAndBase64PasswordSpecified();
            }
            decodedPassword = passwordBase64 != null ? CodePointIterator.ofString((String)passwordBase64).base64Decode().asUtf8String().drainToString() : password;
            mergedConfiguration = mergedConfiguration.useName(userName).usePassword(decodedPassword).useRealm(realm);
        }
lbl29:
        // 5 sources

        context = AuthenticationContext.empty().with(MatchRule.ALL, mergedConfiguration);
        if (useSeparateConnection) {
            try {
                connection = (Connection)endpoint.connect(providerUri, OptionMap.EMPTY, context).get();
            }
            catch (IOException e) {
                throw Messages.log.connectFailed(e);
            }
            provider = new RemoteNamingProvider(connection, context, env);
            connection.getAttachments().attach(RemoteNamingProviderFactory.PROVIDER_KEY, (Object)provider);
            return provider;
        }
        if (env.containsKey("jboss.naming.client.connection")) {
            connection = (Connection)env.get("jboss.naming.client.connection");
            provider = new RemoteNamingProvider(connection, context, env);
            connection.getAttachments().attach(RemoteNamingProviderFactory.PROVIDER_KEY, (Object)provider);
            return provider;
        }
        attachments = endpoint.getAttachments();
        map = (ProviderMap)attachments.getAttachment(RemoteNamingProviderFactory.PROVIDER_MAP_KEY);
        if (map == null && (appearing = (ProviderMap)attachments.attachIfAbsent(RemoteNamingProviderFactory.PROVIDER_MAP_KEY, (Object)(map = new ProviderMap()))) != null) {
            map = appearing;
        }
        if ((provider = (RemoteNamingProvider)map.get(key = new URIKey(providerUri.getScheme(), providerUri.getUserInfo(), providerUri.getHost(), providerUri.getPort()))) == null && (appearing = map.putIfAbsent(key, provider = new RemoteNamingProvider(endpoint, providerUri, context, env))) != null) {
            provider = appearing;
        }
        return provider;
    }

    private Endpoint getEndpoint(FastHashtable<String, Object> env) {
        return env.containsKey("jboss.naming.client.endpoint") ? (Endpoint)env.get("jboss.naming.client.endpoint") : Endpoint.getCurrent();
    }

    private String getStringProperty(String propertyName, FastHashtable<String, Object> env) {
        Object propertyValue = env.get(propertyName);
        return propertyValue == null ? null : (String)propertyValue;
    }

    private static ClassLoader secureGetContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader contextClassLoader = sm != null ? AccessController.doPrivileged(RemoteNamingProviderFactory::getContextClassLoader) : RemoteNamingProviderFactory.getContextClassLoader();
        return contextClassLoader;
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    static final class ProviderMap
    extends ConcurrentHashMap<URIKey, RemoteNamingProvider> {
        ProviderMap() {
        }
    }

    static final class URIKey {
        private final String scheme;
        private final String userInfo;
        private final String host;
        private final int port;
        private final int hashCode;

        URIKey(String scheme, String userInfo, String host, int port) {
            this.scheme = scheme == null ? "" : scheme;
            this.userInfo = userInfo == null ? "" : userInfo;
            this.host = host == null ? "" : host;
            this.port = port;
            this.hashCode = port + 31 * (this.host.hashCode() + 31 * (this.userInfo.hashCode() + 31 * this.scheme.hashCode()));
        }

        public boolean equals(Object o) {
            return this == o || o instanceof URIKey && this.equals((URIKey)o);
        }

        private boolean equals(URIKey key) {
            return this.hashCode == key.hashCode && this.port == key.port && this.scheme.equals(key.scheme) && this.userInfo.equals(key.userInfo) && this.host.equals(key.host);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

