/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.FailedIoFuture;
import org.xnio.IoFuture;

public final class RemoteNamingProvider
implements NamingProvider {
    private static final AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final Endpoint endpoint;
    private final ProviderEnvironment providerEnvironment;

    RemoteNamingProvider(Endpoint endpoint, ProviderEnvironment providerEnvironment, FastHashtable<String, Object> env) {
        this.endpoint = endpoint;
        this.providerEnvironment = providerEnvironment;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public ProviderEnvironment getProviderEnvironment() {
        return this.providerEnvironment;
    }

    public ConnectionPeerIdentity getPeerIdentityForNaming() throws NamingException {
        return (ConnectionPeerIdentity)NamingProvider.super.getPeerIdentityForNaming();
    }

    public ConnectionPeerIdentity getPeerIdentityForNaming(URI location) throws NamingException {
        Assert.checkNotNullParam((String)"location", (Object)location);
        try {
            return this.getPeerIdentity(location);
        }
        catch (AuthenticationException e) {
            throw Messages.log.authenticationFailed(e);
        }
        catch (IOException e) {
            throw Messages.log.connectFailed(e);
        }
    }

    public ConnectionPeerIdentity getPeerIdentity(URI location) throws IOException {
        Assert.checkNotNullParam((String)"location", (Object)location);
        return (ConnectionPeerIdentity)this.getFuturePeerIdentity(location).get();
    }

    public IoFuture<ConnectionPeerIdentity> getFuturePeerIdentity(URI location) {
        return AccessController.doPrivileged(() -> this.getFuturePeerIdentityPrivileged(location));
    }

    private IoFuture<ConnectionPeerIdentity> getFuturePeerIdentityPrivileged(URI location) {
        SSLContext sslContext;
        Supplier<AuthenticationContext> supplier = this.providerEnvironment.getAuthenticationContextSupplier();
        AuthenticationContext context = supplier.get();
        try {
            sslContext = CLIENT.getSSLContext(location, context, "jndi", "jboss");
        }
        catch (GeneralSecurityException e) {
            return new FailedIoFuture(new IOException(e));
        }
        AuthenticationConfiguration authenticationConfiguration = CLIENT.getAuthenticationConfiguration(location, context, -1, "jndi", "jboss");
        return this.endpoint.getConnectedIdentity(location, sslContext, authenticationConfiguration);
    }
}

