/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.hibernate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.hibernate.MethodAdapter;
import org.jboss.as.hibernate.TransformedState;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.TraceClassVisitor;
import org.wildfly.security.manager.WildFlySecurityManager;

public class Hibernate51CompatibilityTransformer
implements ClassFileTransformer {
    private static final Hibernate51CompatibilityTransformer instance = new Hibernate51CompatibilityTransformer();
    private static final File showTransformedClassFolder;
    public static final BasicLogger logger;
    private static final boolean useASM7;
    private static final String markerAlreadyTransformed = "$_org_jboss_as_hibernate_Hibernate51CompatibilityTransformer_transformed_$";

    public static Hibernate51CompatibilityTransformer getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(final ClassLoader loader, final String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (className.startsWith("org/jboss/arquillian") || className.startsWith("org/jboss/as/arquillian") || className.startsWith("org/junit") || className.startsWith("org/jboss/shrinkwrap")) {
            logger.debugf("Hibernate51CompatibilityTransformer ignoring class '%s' from '%s'", (Object)className, (Object)Hibernate51CompatibilityTransformer.getModuleName(loader));
            return null;
        }
        logger.debugf("Hibernate51CompatibilityTransformer transforming deployment class '%s' from '%s'", (Object)className, (Object)Hibernate51CompatibilityTransformer.getModuleName(loader));
        HashSet<String> parentClassesAndInterfaces = new HashSet<String>();
        this.collectClassesAndInterfaces(parentClassesAndInterfaces, loader, className);
        logger.tracef("Class %s extends or implements %s", (Object)className, parentClassesAndInterfaces);
        final boolean rewriteSessionImplementor = this.parentExpectsSharedSessionContractImplementor(parentClassesAndInterfaces);
        final TransformedState transformedState = new TransformedState();
        ClassReader classReader = new ClassReader(classfileBuffer);
        ClassWriter classWriter = new ClassWriter(classReader, 2);
        try (PrintWriter traceAfterPrintWriter = null;){
            classReader.accept(new ClassVisitor(useASM7 ? 458752 : 393216, (ClassVisitor)classWriter){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    transformedState.clear();
                    super.visit(version, access, name, signature, superName, interfaces);
                }

                public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                    if (Hibernate51CompatibilityTransformer.markerAlreadyTransformed.equals(name) && desc.equals("Z")) {
                        transformedState.setAlreadyTransformed(true);
                    }
                    return super.visitField(access, name, desc, signature, value);
                }

                public void visitEnd() {
                    if (transformedState.transformationsMade()) {
                        this.cv.visitField(9, Hibernate51CompatibilityTransformer.markerAlreadyTransformed, "Z", null, null).visitEnd();
                    }
                    super.visitEnd();
                }

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    String descOrig = desc;
                    logger.tracef("method %s, description %s, signature %s", (Object)name, (Object)desc, (Object)signature);
                    if (rewriteSessionImplementor && desc.contains("org/hibernate/engine/spi/SessionImplementor")) {
                        desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                    }
                    if (descOrig != desc) {
                        transformedState.setClassTransformed(true);
                    }
                    return new MethodAdapter(rewriteSessionImplementor, 393216, super.visitMethod(access, name, desc, signature, exceptions), Hibernate51CompatibilityTransformer.getModuleName(loader), className, transformedState);
                }
            }, 0);
            if (!transformedState.transformationsMade()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] result = classWriter.toByteArray();
            try {
                if (showTransformedClassFolder != null) {
                    ClassReader cr = new ClassReader(result);
                    traceAfterPrintWriter = new PrintWriter(new File(showTransformedClassFolder, className.replace('/', '_') + ".asm"));
                    TraceClassVisitor tv = new TraceClassVisitor(traceAfterPrintWriter);
                    cr.accept((ClassVisitor)tv, 0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] byArray = result;
            return byArray;
        }
    }

    private static String getModuleName(ClassLoader loader) {
        if (loader == null) {
            return "(null)";
        }
        if (loader instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)loader).getName();
        }
        return loader.toString();
    }

    private static String replaceSessionImplementor(String desc) {
        return desc.replace("Lorg/hibernate/engine/spi/SessionImplementor;", "Lorg/hibernate/engine/spi/SharedSessionContractImplementor;");
    }

    private boolean parentExpectsSharedSessionContractImplementor(Set parentClassesAndInterfaces) {
        return parentClassesAndInterfaces.contains("org/hibernate/usertype/UserType") || parentClassesAndInterfaces.contains("org/hibernate/usertype/CompositeUserType") || parentClassesAndInterfaces.contains("org/hibernate/usertype/UserCollectionType") || parentClassesAndInterfaces.contains("org/hibernate/usertype/UserVersionType") || parentClassesAndInterfaces.contains("org/hibernate/type/Type") || parentClassesAndInterfaces.contains("org/hibernate/type/SingleColumnType") || parentClassesAndInterfaces.contains("org/hibernate/type/AbstractStandardBasicType") || parentClassesAndInterfaces.contains("org/hibernate/type/ProcedureParameterExtractionAware") || parentClassesAndInterfaces.contains("org/hibernate/type/ProcedureParameterNamedBinder") || parentClassesAndInterfaces.contains("org/hibernate/type/VersionType") || parentClassesAndInterfaces.contains("org/hibernate/collection/spi/PersistentCollection");
    }

    private void collectClassesAndInterfaces(final Set<String> classesAndInterfaces, final ClassLoader classLoader, String className) {
        if (className == null || "java/lang/Object".equals(className)) {
            return;
        }
        try (InputStream is = classLoader.getResourceAsStream(className.replace('.', '/') + ".class");){
            ClassReader classReader = new ClassReader(is);
            classReader.accept(new ClassVisitor(useASM7 ? 458752 : 393216){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (interfaces != null) {
                        for (String interfaceName : interfaces) {
                            classesAndInterfaces.add(interfaceName);
                            Hibernate51CompatibilityTransformer.this.collectClassesAndInterfaces(classesAndInterfaces, classLoader, interfaceName);
                        }
                    }
                    classesAndInterfaces.add(superName);
                    Hibernate51CompatibilityTransformer.this.collectClassesAndInterfaces(classesAndInterfaces, classLoader, superName);
                }

                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                    if (innerName != null) {
                        classesAndInterfaces.add(innerName);
                    }
                }
            }, 0);
        }
        catch (IOException e) {
            logger.debugf("Unable to open class file %s, due to exception %s", (Object)className, (Object)e);
        }
    }

    private static int getMajorJavaVersion() {
        Matcher matcher;
        int major = 8;
        String version = WildFlySecurityManager.getPropertyPrivileged((String)"java.specification.version", null);
        if (version != null && (matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(version)).find()) {
            major = Integer.valueOf(matcher.group(1));
        }
        return major;
    }

    static {
        logger = Logger.getLogger((String)"org.jboss.as.hibernate.transformer");
        String folderName = WildFlySecurityManager.getPropertyPrivileged((String)"Hibernate51CompatibilityTransformer.showTransformedClassFolder", null);
        showTransformedClassFolder = folderName != null ? new File(folderName) : null;
        useASM7 = Hibernate51CompatibilityTransformer.getMajorJavaVersion() >= 11;
    }
}

