/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.naming;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.naming.InitialContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

final class JNDIServiceListener
implements ServiceListener {
    private static final String OSGI_JNDI_URL_SCHEME = "osgi.jndi.url.scheme";
    private final BundleContext bundleContext;

    public JNDIServiceListener(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        try {
            ServiceReference[] refs = bundleContext.getServiceReferences(ObjectFactory.class.getName(), null);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    this.handleJNDIRegistration(ref, true);
                }
            }
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        switch (event.getType()) {
            case 1: {
                this.handleJNDIRegistration(ref, true);
                break;
            }
            case 4: {
                this.handleJNDIRegistration(ref, false);
            }
        }
    }

    private void handleJNDIRegistration(ServiceReference ref, boolean register) {
        String[] objClasses;
        for (String objClass : objClasses = (String[])ref.getProperty("objectClass")) {
            if (!ObjectFactory.class.getName().equals(objClass)) continue;
            for (String scheme : JNDIServiceListener.getStringPlusProperty(ref.getProperty(OSGI_JNDI_URL_SCHEME))) {
                if (register) {
                    InitialContext.addUrlContextFactory((String)scheme, (ObjectFactory)((ObjectFactory)this.bundleContext.getService(ref)));
                    continue;
                }
                InitialContext.removeUrlContextFactory((String)scheme, (ObjectFactory)((ObjectFactory)this.bundleContext.getService(ref)));
            }
        }
    }

    private static Collection<String> getStringPlusProperty(Object property) {
        if (property instanceof Collection) {
            return (Collection)property;
        }
        if (property instanceof String[]) {
            return Arrays.asList((String[])property);
        }
        if (property instanceof String) {
            return Collections.singleton((String)property);
        }
        return Collections.emptyList();
    }
}

