/*
 * JBoss, Home of Professional Open Source
 * Copyright 2022, Red Hat Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.test.integration.transaction;

import java.io.IOException;
import java.io.Writer;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

import org.jboss.as.test.integration.transactions.TestXAResource;

@WebServlet(name = "TransactionTimeoutLeakServlet", urlPatterns = {"/timeout"})
public class TransactionTimeoutLeakServlet extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            final TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
            final String second = req.getParameter("second");
            if (second != null) {
                final int timeoutValue = Integer.parseInt(second);
                if (timeoutValue > 0) {
                    tm.setTransactionTimeout(timeoutValue);
                }
            }

            XAResource xaer = new TestXAResource();
            tm.begin();
            tm.getTransaction().enlistResource(xaer);
            int effectiveTimeout = xaer.getTransactionTimeout();
            tm.commit();

            Writer writer = resp.getWriter();
            writer.write(String.valueOf(effectiveTimeout));
        } catch (Exception e) {
            throw new ServletException(e);
        }
    }
}
