/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.io.File;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQDeleteAddressException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateMetaDataException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQIncompatibleClientServerException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidQueueConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException;
import org.apache.activemq.artemis.api.core.ActiveMQUnexpectedRoutingTypeForAddress;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;

public class ActiveMQMessageBundle_$bundle
implements ActiveMQMessageBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQMessageBundle_$bundle INSTANCE = new ActiveMQMessageBundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String activationForServer = "AMQ119000: Activation for server {0}";
    private static final String generatingThreadDump = "AMQ119001: Generating thread dump";
    private static final String threadDump = "AMQ119002: Thread {0} name = {1} id = {2} group = {3}";
    private static final String endThreadDump = "AMQ119003: End Thread dump";
    private static final String serverDescribe = "AMQ119004: Information about server {0}\nCluster Connection:{1}";
    private static final String connectionsClosedByManagement = "AMQ119005: connections for {0} closed by management";
    private static final String notJournalImpl = "AMQ119006: journals are not JournalImpl. You can''t set a replicator!";
    private static final String replicationUnhandledError = "AMQ119007: unhandled error during replication";
    private static final String replicationTooManyJournals = "AMQ119008: Live Node contains more journals than the backup node. Probably a version match error";
    private static final String replicationUnhandledFileType = "AMQ119009: Unhandled file type {0}";
    private static final String replicationBackupUpToDate = "AMQ119010: Remote Backup can not be up-to-date!";
    private static final String replicationUnhandledDataType = "AMQ119011: unhandled data type!";
    private static final String noBindingForDivert = "AMQ119012: No binding for divert {0}";
    private static final String bindingNotDivert = "AMQ119013: Binding {0} is not a divert";
    private static final String clientExited = "AMQ119014: Did not receive data from {0} within the {1}ms connection TTL. The connection will now be closed.";
    private static final String divertWithNoName = "AMQ119015: Must specify a name for each divert. This one will not be deployed.";
    private static final String noSuchQueue = "AMQ119017: Queue {0} does not exist";
    private static final String bindingAlreadyExists = "AMQ119018: Binding already exists {0}";
    private static final String queueAlreadyExists = "AMQ119019: Queue {0} already exists on address {1}";
    private static final String invalidFilter = "AMQ119020: Invalid filter: {0}";
    private static final String messageIdNotAssigned = "AMQ119021: MessageId was not assigned to Message";
    private static final String journalsNotInSync = "AMQ119022: Cannot compare journals if not in sync!";
    private static final String serverNotBackupServer = "AMQ119023: Connected server is not a backup server";
    private static final String alreadyHaveReplicationServer = "AMQ119024: Backup replication server is already connected to another server";
    private static final String cannotDeleteQueue = "AMQ119025: Cannot delete queue {0} on binding {1} - it has consumers = {2}";
    private static final String backupServerNotInSync = "AMQ119026: Backup Server was not yet in sync with live";
    private static final String consumerNoReference = "AMQ119027: Could not find reference on consumer ID={0}, messageId = {1} queue = {2}";
    private static final String consumerDoesntExist = "AMQ119028: Consumer {0} doesn''t exist on the server";
    private static final String noAddress = "AMQ119029: No address configured on the Server''s Session";
    private static final String largeMessageNotInitialised = "AMQ119030: large-message not initialized on server";
    private static final String unableToValidateUser = "AMQ119031: Unable to validate user from {0}. Username: {1}; SSL certificate subject DN: {2}";
    private static final String userNoPermissions = "AMQ119032: User: {0} does not have permission=''{1}'' on address {2}";
    private static final String incompatibleClientServer = "AMQ119033: Server and client versions incompatible";
    private static final String serverNotStarted = "AMQ119034: Server not started";
    private static final String duplicateMetadata = "AMQ119035: Metadata {0}={1} had been set already";
    private static final String invalidType = "AMQ119036: Invalid type: {0}";
    private static final String emptyOrNull = "AMQ119038: {0} must neither be null nor empty";
    private static final String greaterThanZero2 = "AMQ119039: {0}  must be greater than 0 (actual value: {1})";
    private static final String notPercent = "AMQ119040: {0} must be a valid percentual value between 0 and 100 (actual value: {1})";
    private static final String greaterThanMinusOne = "AMQ119041: {0}  must be equals to -1 or greater than 0 (actual value: {1})";
    private static final String greaterThanZeroOrMinusOne = "AMQ119042: {0}  must be equals to -1 or greater or equals to 0 (actual value: {1})";
    private static final String mustbeBetween = "AMQ119043: {0} must be between {1} and {2} inclusive (actual value: {3})";
    private static final String invalidJournalType = "AMQ119044: Invalid journal type {0}";
    private static final String invalidAddressFullPolicyType = "AMQ119045: Invalid address full message policy type {0}";
    private static final String greaterThanZero1 = "AMQ119046: invalid value: {0} count must be greater than 0";
    private static final String periodMustGreaterThanZero = "AMQ119047: invalid value: {0} sample period must be greater than 0";
    private static final String invalidNewPriority = "AMQ119048: invalid new Priority value: {0}. It must be between 0 and 9 (both included)";
    private static final String noQueueFound = "AMQ119049: No queue found for {0}";
    private static final String invalidJournal = "AMQ119050: Only NIO and AsyncIO are supported journals";
    private static final String invalidJournalType2 = "AMQ119051: Invalid journal type {0}";
    private static final String cannotCreateDir = "AMQ119052: Directory {0} does not exist and cannot be created";
    private static final String cannotConvertToInt = "AMQ119054: Cannot convert to int";
    private static final String routeNameIsNull = "AMQ119055: Routing name is null";
    private static final String clusterNameIsNull = "AMQ119056: Cluster name is null";
    private static final String addressIsNull = "AMQ119057: Address is null";
    private static final String bindingTypeNotSpecified = "AMQ119058: Binding type not specified";
    private static final String bindingIdNotSpecified = "AMQ119059: Binding ID is null";
    private static final String distancenotSpecified = "AMQ119060: Distance is null";
    private static final String connectionExists = "AMQ119061: Connection already exists with id {0}";
    private static final String acceptorExists = "AMQ119062: Acceptor with id {0} already registered";
    private static final String acceptorNotExists = "AMQ119063: Acceptor with id {0} not registered";
    private static final String unknownProtocol = "AMQ119064: Unknown protocol {0}";
    private static final String nodeIdNull = "AMQ119065: node id is null";
    private static final String queueNameIsNull = "AMQ119066: Queue name is null";
    private static final String cannotFindResource = "AMQ119067: Cannot find resource with name {0}";
    private static final String noGetterMethod = "AMQ119068: no getter method for {0}";
    private static final String noOperation = "AMQ119069: no operation {0}/{1}";
    private static final String nullMatch = "AMQ119070: match can not be null";
    private static final String invalidMatch = "AMQ119071: # can only be at end of match";
    private static final String nullUser = "AMQ119072: User cannot be null";
    private static final String nullPassword = "AMQ119073: Password cannot be null";
    private static final String errorCreatingTransformerClass = "AMQ119074: Error instantiating transformer class {0}";
    private static final String autoConvertError = "AMQ119075: method autoEncode doesn''t know how to convert {0} yet";
    private static final String destroyConnectionWithSessionMetadataHeader = "AMQ119076: Executing destroyConnection with {0}={1} through management''s request";
    private static final String destroyConnectionWithSessionMetadataClosingConnection = "AMQ119077: Closing connection {0}";
    private static final String destroyConnectionWithSessionMetadataSendException = "AMQ119078: Disconnected per admin''s request on {0}={1}";
    private static final String destroyConnectionWithSessionMetadataNoSessionFound = "AMQ119079: No session found with {0}={1}";
    private static final String invalidPageIO = "AMQ119080: Invalid Page IO, PagingManager was stopped or closed";
    private static final String noDiscoveryGroupFound = "AMQ119081: No Discovery Group configuration named {0} found";
    private static final String queueSubscriptionBelongsToDifferentAddress = "AMQ119082: Queue {0} already exists on another subscription";
    private static final String queueSubscriptionBelongsToDifferentFilter = "AMQ119083: Queue {0} has a different filter than requested";
    private static final String unableToValidateClusterUser = "AMQ119099: Unable to authenticate cluster user: {0}";
    private static final String journalDirIsFile = "AMQ119100: Trying to move a journal file that refers to a file instead of a directory: {0}";
    private static final String couldNotMoveJournal = "AMQ119101: error trying to backup journal files at directory: {0}";
    private static final String addressIsFull = "AMQ119102: Address \"{0}\" is full.";
    private static final String noConfigurationFoundForScaleDown = "AMQ119103: No Connectors or Discovery Groups configured for Scale Down";
    private static final String groupWhileStopping = "AMQ119104: Server is stopping. Message grouping not allowed";
    private static final String invalidSlowConsumerPolicyType = "AMQ119106: Invalid slow consumer policy type {0}";
    private static final String consumerConnectionsClosedByManagement = "AMQ119107: consumer connections for address {0} closed by management";
    private static final String connectionsForUserClosedByManagement = "AMQ119108: connections for user {0} closed by management";
    private static final String unsupportedHAPolicyConfiguration = "AMQ119109: unsupported HA Policy Configuration {0}";
    private static final String sessionLimitReached = "AMQ119110: Too many sessions for user ''{0}''. Sessions allowed: {1}.";
    private static final String queueLimitReached = "AMQ119111: Too many queues created by user ''{0}''. Queues allowed: {1}.";
    private static final String cannotSetMBeanserver = "AMQ119112: Cannot set MBeanServer during startup or while started";
    private static final String invalidMessageLoadBalancingType = "AMQ119113: Invalid message load balancing type {0}";
    private static final String replicationSynchronizationTimeout = "AMQ119114: Replication synchronization process timed out after waiting {0} milliseconds";
    private static final String liveBackupMismatch = "AMQ119115: Colocated Policy hasn''t different type live and backup";
    private static final String acceptorUnavailable = "AMQ119116: Netty Acceptor unavailable";
    private static final String replicatorIsNull = "AMQ119117: Replicator is null. Replication was likely terminated.";
    private static final String methodNotApplicable = "AMQ119118: Management method not applicable for current server configuration";
    private static final String diskBeyondLimit = "AMQ119119: Disk Capacity is Low, cannot produce more messages.";
    private static final String connectionWithIDClosedByManagement = "AMQ119120: connection with ID {0} closed by management";
    private static final String maxConsumerLimitReachedForQueue = "AMQ119200: Maximum Consumer Limit Reached on Queue:(address={0},queue={1})";
    private static final String unexpectedRoutingTypeForAddress = "AMQ119201: Expected Routing Type {1} but found {2} for address {0}";
    private static final String invalidQueueConfiguration = "AMQ119202: Invalid Queue Configuration for Queue {0}, Address {1}.  Expected {2} to be {3} but was {4}";
    private static final String addressDoesNotExist = "AMQ119203: Address Does Not Exist: {0}";
    private static final String addressAlreadyExists = "AMQ119204: Address already exists: {0}";
    private static final String addressHasBindings = "AMQ119205: Address {0} has bindings";
    private static final String invalidMaxConsumers = "AMQ119206: Queue {0} has invalid max consumer setting: {1}";
    private static final String invalidRoutingTypeForAddress = "AMQ119207: Can not create queue with routing type: {0}, Supported routing types for address: {1} are {2}";
    private static final String invalidRoutingType = "AMQ119208: Invalid routing type {0}";
    private static final String invalidRoutingTypeDelete = "AMQ119209: Can''t remove routing type {0}, queues exists for address: {1}. Please delete queues before removing this routing type.";
    private static final String invalidMaxConsumersUpdate = "AMQ119210: Can''t update queue {0} with maxConsumers: {1}. Current consumers are {2}.";
    private static final String invalidRoutingTypeUpdate = "AMQ119211: Can''t update queue {0} with routing type: {1}, Supported routing types for address: {2} are {3}";
    private static final String invalidDeletionPolicyType = "AMQ119212: Invalid deletion policy type {0}";
    private static final String userNoPermissionsQueue = "AMQ119213: User: {0} does not have permission=''{1}'' for queue {2} on address {3}";
    private static final String notPercentOrMinusOne = "AMQ119214: {0} must be a valid percentage value between 0 and 100 or -1 (actual value: {1})";

    protected ActiveMQMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String activationForServer$str() {
        return activationForServer;
    }

    @Override
    public final String activationForServer(ActiveMQServer server) {
        return this._formatMessage(this.activationForServer$str(), server);
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String generatingThreadDump$str() {
        return generatingThreadDump;
    }

    @Override
    public final String generatingThreadDump() {
        return this.generatingThreadDump$str();
    }

    protected String threadDump$str() {
        return threadDump;
    }

    @Override
    public final String threadDump(Thread key, String name, Long id, ThreadGroup threadGroup) {
        return this._formatMessage(this.threadDump$str(), key, name, id, threadGroup);
    }

    protected String endThreadDump$str() {
        return endThreadDump;
    }

    @Override
    public final String endThreadDump() {
        return String.format(this.getLoggingLocale(), this.endThreadDump$str(), new Object[0]);
    }

    protected String serverDescribe$str() {
        return serverDescribe;
    }

    @Override
    public final String serverDescribe(String identity, String describe) {
        return this._formatMessage(this.serverDescribe$str(), identity, describe);
    }

    protected String connectionsClosedByManagement$str() {
        return connectionsClosedByManagement;
    }

    @Override
    public final ActiveMQInternalErrorException connectionsClosedByManagement(String ipAddress) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.connectionsClosedByManagement$str(), ipAddress));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notJournalImpl$str() {
        return notJournalImpl;
    }

    @Override
    public final ActiveMQInternalErrorException notJournalImpl() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.notJournalImpl$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledError$str() {
        return replicationUnhandledError;
    }

    @Override
    public final ActiveMQInternalErrorException replicationUnhandledError(Exception e) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.replicationUnhandledError$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationTooManyJournals$str() {
        return replicationTooManyJournals;
    }

    @Override
    public final ActiveMQInternalErrorException replicationTooManyJournals() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.replicationTooManyJournals$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledFileType$str() {
        return replicationUnhandledFileType;
    }

    @Override
    public final ActiveMQInternalErrorException replicationUnhandledFileType(ReplicationSyncFileMessage.FileType fileType) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.replicationUnhandledFileType$str(), new Object[]{fileType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationBackupUpToDate$str() {
        return replicationBackupUpToDate;
    }

    @Override
    public final ActiveMQInternalErrorException replicationBackupUpToDate() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.replicationBackupUpToDate$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledDataType$str() {
        return replicationUnhandledDataType;
    }

    @Override
    public final ActiveMQInternalErrorException replicationUnhandledDataType() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.replicationUnhandledDataType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noBindingForDivert$str() {
        return noBindingForDivert;
    }

    @Override
    public final ActiveMQInternalErrorException noBindingForDivert(SimpleString name) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.noBindingForDivert$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingNotDivert$str() {
        return bindingNotDivert;
    }

    @Override
    public final ActiveMQInternalErrorException bindingNotDivert(SimpleString name) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.bindingNotDivert$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clientExited$str() {
        return clientExited;
    }

    @Override
    public final ActiveMQConnectionTimedOutException clientExited(String remoteAddress, long ttl) {
        ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(this._formatMessage(this.clientExited$str(), remoteAddress, ttl));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String divertWithNoName$str() {
        return divertWithNoName;
    }

    @Override
    public final ActiveMQInternalErrorException divertWithNoName() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this.divertWithNoName$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchQueue$str() {
        return noSuchQueue;
    }

    @Override
    public final ActiveMQNonExistentQueueException noSuchQueue(SimpleString queueName) {
        ActiveMQNonExistentQueueException result = new ActiveMQNonExistentQueueException(this._formatMessage(this.noSuchQueue$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingAlreadyExists$str() {
        return bindingAlreadyExists;
    }

    @Override
    public final ActiveMQQueueExistsException bindingAlreadyExists(Binding binding) {
        ActiveMQQueueExistsException result = new ActiveMQQueueExistsException(this._formatMessage(this.bindingAlreadyExists$str(), binding));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueAlreadyExists$str() {
        return queueAlreadyExists;
    }

    @Override
    public final ActiveMQQueueExistsException queueAlreadyExists(SimpleString queueName, SimpleString addressName) {
        ActiveMQQueueExistsException result = new ActiveMQQueueExistsException(this._formatMessage(this.queueAlreadyExists$str(), queueName, addressName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFilter$str() {
        return invalidFilter;
    }

    @Override
    public final ActiveMQInvalidFilterExpressionException invalidFilter(Throwable e, SimpleString filter) {
        ActiveMQInvalidFilterExpressionException result = new ActiveMQInvalidFilterExpressionException(this._formatMessage(this.invalidFilter$str(), filter));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageIdNotAssigned$str() {
        return messageIdNotAssigned;
    }

    @Override
    public final ActiveMQIllegalStateException messageIdNotAssigned() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.messageIdNotAssigned$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String journalsNotInSync$str() {
        return journalsNotInSync;
    }

    @Override
    public final ActiveMQIllegalStateException journalsNotInSync() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.journalsNotInSync$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotBackupServer$str() {
        return serverNotBackupServer;
    }

    @Override
    public final ActiveMQIllegalStateException serverNotBackupServer() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.serverNotBackupServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String alreadyHaveReplicationServer$str() {
        return alreadyHaveReplicationServer;
    }

    @Override
    public final ActiveMQIllegalStateException alreadyHaveReplicationServer() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.alreadyHaveReplicationServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeleteQueue$str() {
        return cannotDeleteQueue;
    }

    @Override
    public final ActiveMQIllegalStateException cannotDeleteQueue(SimpleString name, SimpleString queueName, String s) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.cannotDeleteQueue$str(), name, queueName, s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backupServerNotInSync$str() {
        return backupServerNotInSync;
    }

    @Override
    public final ActiveMQIllegalStateException backupServerNotInSync() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.backupServerNotInSync$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerNoReference$str() {
        return consumerNoReference;
    }

    @Override
    public final ActiveMQIllegalStateException consumerNoReference(Long id, Long messageID, SimpleString name) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.consumerNoReference$str(), id, messageID, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerDoesntExist$str() {
        return consumerDoesntExist;
    }

    @Override
    public final ActiveMQIllegalStateException consumerDoesntExist(long consumerID) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.consumerDoesntExist$str(), consumerID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAddress$str() {
        return noAddress;
    }

    @Override
    public final ActiveMQIllegalStateException noAddress() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.noAddress$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String largeMessageNotInitialised$str() {
        return largeMessageNotInitialised;
    }

    @Override
    public final ActiveMQIllegalStateException largeMessageNotInitialised() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.largeMessageNotInitialised$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToValidateUser$str() {
        return unableToValidateUser;
    }

    @Override
    public final ActiveMQSecurityException unableToValidateUser(String remoteAddress, String user, String certMessage) {
        ActiveMQSecurityException result = new ActiveMQSecurityException(this._formatMessage(this.unableToValidateUser$str(), remoteAddress, user, certMessage));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userNoPermissions$str() {
        return userNoPermissions;
    }

    @Override
    public final ActiveMQSecurityException userNoPermissions(String username, CheckType checkType, String saddress) {
        ActiveMQSecurityException result = new ActiveMQSecurityException(this._formatMessage(this.userNoPermissions$str(), new Object[]{username, checkType, saddress}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompatibleClientServer$str() {
        return incompatibleClientServer;
    }

    @Override
    public final ActiveMQIncompatibleClientServerException incompatibleClientServer() {
        ActiveMQIncompatibleClientServerException result = new ActiveMQIncompatibleClientServerException(String.format(this.getLoggingLocale(), this.incompatibleClientServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotStarted$str() {
        return serverNotStarted;
    }

    @Override
    public final ActiveMQSessionCreationException serverNotStarted() {
        ActiveMQSessionCreationException result = new ActiveMQSessionCreationException(String.format(this.getLoggingLocale(), this.serverNotStarted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateMetadata$str() {
        return duplicateMetadata;
    }

    @Override
    public final ActiveMQDuplicateMetaDataException duplicateMetadata(String key, String data) {
        ActiveMQDuplicateMetaDataException result = new ActiveMQDuplicateMetaDataException(this._formatMessage(this.duplicateMetadata$str(), key, data));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidType$str() {
        return invalidType;
    }

    @Override
    public final IllegalArgumentException invalidType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String emptyOrNull$str() {
        return emptyOrNull;
    }

    @Override
    public final IllegalArgumentException emptyOrNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.emptyOrNull$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZero2$str() {
        return greaterThanZero2;
    }

    @Override
    public final IllegalArgumentException greaterThanZero(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.greaterThanZero2$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notPercent$str() {
        return notPercent;
    }

    @Override
    public final IllegalArgumentException notPercent(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.notPercent$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanMinusOne$str() {
        return greaterThanMinusOne;
    }

    @Override
    public final IllegalArgumentException greaterThanMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.greaterThanMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZeroOrMinusOne$str() {
        return greaterThanZeroOrMinusOne;
    }

    @Override
    public final IllegalArgumentException greaterThanZeroOrMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.greaterThanZeroOrMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustbeBetween$str() {
        return mustbeBetween;
    }

    @Override
    public final IllegalArgumentException mustbeBetween(String name, Integer minPriority, Integer maxPriority, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.mustbeBetween$str(), name, minPriority, maxPriority, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournalType$str() {
        return invalidJournalType;
    }

    @Override
    public final IllegalArgumentException invalidJournalType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidJournalType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAddressFullPolicyType$str() {
        return invalidAddressFullPolicyType;
    }

    @Override
    public final IllegalArgumentException invalidAddressFullPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidAddressFullPolicyType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZero1$str() {
        return greaterThanZero1;
    }

    @Override
    public final IllegalArgumentException greaterThanZero(Integer count) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.greaterThanZero1$str(), count));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String periodMustGreaterThanZero$str() {
        return periodMustGreaterThanZero;
    }

    @Override
    public final IllegalArgumentException periodMustGreaterThanZero(Long newPeriod) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.periodMustGreaterThanZero$str(), newPeriod));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNewPriority$str() {
        return invalidNewPriority;
    }

    @Override
    public final IllegalArgumentException invalidNewPriority(Integer period) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidNewPriority$str(), period));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noQueueFound$str() {
        return noQueueFound;
    }

    @Override
    public final IllegalArgumentException noQueueFound(String otherQueueName) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.noQueueFound$str(), otherQueueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournal$str() {
        return invalidJournal;
    }

    @Override
    public final IllegalArgumentException invalidJournal() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidJournal$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournalType2$str() {
        return invalidJournalType2;
    }

    @Override
    public final IllegalArgumentException invalidJournalType2(JournalType journalType) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidJournalType2$str(), new Object[]{journalType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateDir$str() {
        return cannotCreateDir;
    }

    @Override
    public final IllegalArgumentException cannotCreateDir(String dir) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.cannotCreateDir$str(), dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertToInt$str() {
        return cannotConvertToInt;
    }

    @Override
    public final IllegalArgumentException cannotConvertToInt() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotConvertToInt$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String routeNameIsNull$str() {
        return routeNameIsNull;
    }

    @Override
    public final IllegalArgumentException routeNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.routeNameIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clusterNameIsNull$str() {
        return clusterNameIsNull;
    }

    @Override
    public final IllegalArgumentException clusterNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.clusterNameIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressIsNull$str() {
        return addressIsNull;
    }

    @Override
    public final IllegalArgumentException addressIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.addressIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingTypeNotSpecified$str() {
        return bindingTypeNotSpecified;
    }

    @Override
    public final IllegalArgumentException bindingTypeNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.bindingTypeNotSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingIdNotSpecified$str() {
        return bindingIdNotSpecified;
    }

    @Override
    public final IllegalArgumentException bindingIdNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.bindingIdNotSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String distancenotSpecified$str() {
        return distancenotSpecified;
    }

    @Override
    public final IllegalArgumentException distancenotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.distancenotSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionExists$str() {
        return connectionExists;
    }

    @Override
    public final IllegalArgumentException connectionExists(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.connectionExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorExists$str() {
        return acceptorExists;
    }

    @Override
    public final IllegalArgumentException acceptorExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.acceptorExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorNotExists$str() {
        return acceptorNotExists;
    }

    @Override
    public final IllegalArgumentException acceptorNotExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.acceptorNotExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownProtocol$str() {
        return unknownProtocol;
    }

    @Override
    public final IllegalArgumentException unknownProtocol(String protocol) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.unknownProtocol$str(), protocol));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeIdNull$str() {
        return nodeIdNull;
    }

    @Override
    public final IllegalArgumentException nodeIdNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nodeIdNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueNameIsNull$str() {
        return queueNameIsNull;
    }

    @Override
    public final IllegalArgumentException queueNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.queueNameIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindResource$str() {
        return cannotFindResource;
    }

    @Override
    public final IllegalArgumentException cannotFindResource(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.cannotFindResource$str(), resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noGetterMethod$str() {
        return noGetterMethod;
    }

    @Override
    public final IllegalArgumentException noGetterMethod(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.noGetterMethod$str(), resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noOperation$str() {
        return noOperation;
    }

    @Override
    public final IllegalArgumentException noOperation(String operation, Integer length) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.noOperation$str(), operation, length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullMatch$str() {
        return nullMatch;
    }

    @Override
    public final IllegalArgumentException nullMatch() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullMatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMatch$str() {
        return invalidMatch;
    }

    @Override
    public final IllegalArgumentException invalidMatch() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidMatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullUser$str() {
        return nullUser;
    }

    @Override
    public final IllegalArgumentException nullUser() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullUser$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullPassword$str() {
        return nullPassword;
    }

    @Override
    public final IllegalArgumentException nullPassword() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullPassword$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatingTransformerClass$str() {
        return errorCreatingTransformerClass;
    }

    @Override
    public final IllegalArgumentException errorCreatingTransformerClass(Exception e, String transformerClassName) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.errorCreatingTransformerClass$str(), transformerClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String autoConvertError$str() {
        return autoConvertError;
    }

    public final IllegalArgumentException autoConvertError(Class<?> aClass) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.autoConvertError$str(), aClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destroyConnectionWithSessionMetadataHeader$str() {
        return destroyConnectionWithSessionMetadataHeader;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataHeader(String key, String value) {
        return this._formatMessage(this.destroyConnectionWithSessionMetadataHeader$str(), key, value);
    }

    protected String destroyConnectionWithSessionMetadataClosingConnection$str() {
        return destroyConnectionWithSessionMetadataClosingConnection;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataClosingConnection(String serverSessionString) {
        return this._formatMessage(this.destroyConnectionWithSessionMetadataClosingConnection$str(), serverSessionString);
    }

    protected String destroyConnectionWithSessionMetadataSendException$str() {
        return destroyConnectionWithSessionMetadataSendException;
    }

    @Override
    public final ActiveMQDisconnectedException destroyConnectionWithSessionMetadataSendException(String key, String value) {
        ActiveMQDisconnectedException result = new ActiveMQDisconnectedException(this._formatMessage(this.destroyConnectionWithSessionMetadataSendException$str(), key, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destroyConnectionWithSessionMetadataNoSessionFound$str() {
        return destroyConnectionWithSessionMetadataNoSessionFound;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataNoSessionFound(String key, String value) {
        return this._formatMessage(this.destroyConnectionWithSessionMetadataNoSessionFound$str(), key, value);
    }

    protected String invalidPageIO$str() {
        return invalidPageIO;
    }

    @Override
    public final ActiveMQIllegalStateException invalidPageIO() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.invalidPageIO$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDiscoveryGroupFound$str() {
        return noDiscoveryGroupFound;
    }

    @Override
    public final ActiveMQException noDiscoveryGroupFound(DiscoveryGroupConfiguration dg) {
        ActiveMQException result = new ActiveMQException(this._formatMessage(this.noDiscoveryGroupFound$str(), dg));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueSubscriptionBelongsToDifferentAddress$str() {
        return queueSubscriptionBelongsToDifferentAddress;
    }

    @Override
    public final ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentAddress(SimpleString queueName) {
        ActiveMQInvalidTransientQueueUseException result = new ActiveMQInvalidTransientQueueUseException(this._formatMessage(this.queueSubscriptionBelongsToDifferentAddress$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueSubscriptionBelongsToDifferentFilter$str() {
        return queueSubscriptionBelongsToDifferentFilter;
    }

    @Override
    public final ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentFilter(SimpleString queueName) {
        ActiveMQInvalidTransientQueueUseException result = new ActiveMQInvalidTransientQueueUseException(this._formatMessage(this.queueSubscriptionBelongsToDifferentFilter$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToValidateClusterUser$str() {
        return unableToValidateClusterUser;
    }

    @Override
    public final ActiveMQClusterSecurityException unableToValidateClusterUser(String user) {
        ActiveMQClusterSecurityException result = new ActiveMQClusterSecurityException(this._formatMessage(this.unableToValidateClusterUser$str(), user));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String journalDirIsFile$str() {
        return journalDirIsFile;
    }

    @Override
    public final IllegalStateException journalDirIsFile(File fDir) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.journalDirIsFile$str(), fDir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotMoveJournal$str() {
        return couldNotMoveJournal;
    }

    @Override
    public final IllegalStateException couldNotMoveJournal(File dir) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.couldNotMoveJournal$str(), dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressIsFull$str() {
        return addressIsFull;
    }

    @Override
    public final ActiveMQAddressFullException addressIsFull(String addressName) {
        ActiveMQAddressFullException result = new ActiveMQAddressFullException(this._formatMessage(this.addressIsFull$str(), addressName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noConfigurationFoundForScaleDown$str() {
        return noConfigurationFoundForScaleDown;
    }

    @Override
    public final ActiveMQException noConfigurationFoundForScaleDown() {
        ActiveMQException result = new ActiveMQException(String.format(this.getLoggingLocale(), this.noConfigurationFoundForScaleDown$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String groupWhileStopping$str() {
        return groupWhileStopping;
    }

    @Override
    public final ActiveMQException groupWhileStopping() {
        ActiveMQException result = new ActiveMQException(String.format(this.getLoggingLocale(), this.groupWhileStopping$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSlowConsumerPolicyType$str() {
        return invalidSlowConsumerPolicyType;
    }

    @Override
    public final IllegalArgumentException invalidSlowConsumerPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidSlowConsumerPolicyType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerConnectionsClosedByManagement$str() {
        return consumerConnectionsClosedByManagement;
    }

    @Override
    public final ActiveMQInternalErrorException consumerConnectionsClosedByManagement(String address) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.consumerConnectionsClosedByManagement$str(), address));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionsForUserClosedByManagement$str() {
        return connectionsForUserClosedByManagement;
    }

    @Override
    public final ActiveMQInternalErrorException connectionsForUserClosedByManagement(String userName) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.connectionsForUserClosedByManagement$str(), userName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedHAPolicyConfiguration$str() {
        return unsupportedHAPolicyConfiguration;
    }

    @Override
    public final ActiveMQIllegalStateException unsupportedHAPolicyConfiguration(Object o) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.unsupportedHAPolicyConfiguration$str(), o));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sessionLimitReached$str() {
        return sessionLimitReached;
    }

    @Override
    public final ActiveMQSessionCreationException sessionLimitReached(String username, int limit) {
        ActiveMQSessionCreationException result = new ActiveMQSessionCreationException(this._formatMessage(this.sessionLimitReached$str(), username, limit));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueLimitReached$str() {
        return queueLimitReached;
    }

    @Override
    public final ActiveMQSessionCreationException queueLimitReached(String username, int limit) {
        ActiveMQSessionCreationException result = new ActiveMQSessionCreationException(this._formatMessage(this.queueLimitReached$str(), username, limit));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSetMBeanserver$str() {
        return cannotSetMBeanserver;
    }

    @Override
    public final IllegalStateException cannotSetMBeanserver() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotSetMBeanserver$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMessageLoadBalancingType$str() {
        return invalidMessageLoadBalancingType;
    }

    @Override
    public final IllegalArgumentException invalidMessageLoadBalancingType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidMessageLoadBalancingType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationSynchronizationTimeout$str() {
        return replicationSynchronizationTimeout;
    }

    @Override
    public final IllegalStateException replicationSynchronizationTimeout(long timeout) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.replicationSynchronizationTimeout$str(), timeout));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String liveBackupMismatch$str() {
        return liveBackupMismatch;
    }

    @Override
    public final ActiveMQIllegalStateException liveBackupMismatch() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this.liveBackupMismatch$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorUnavailable$str() {
        return acceptorUnavailable;
    }

    @Override
    public final IllegalStateException acceptorUnavailable() {
        IllegalStateException result = new IllegalStateException(this.acceptorUnavailable$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicatorIsNull$str() {
        return replicatorIsNull;
    }

    @Override
    public final ActiveMQIllegalStateException replicatorIsNull() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.replicatorIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String methodNotApplicable$str() {
        return methodNotApplicable;
    }

    @Override
    public final IllegalStateException methodNotApplicable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.methodNotApplicable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String diskBeyondLimit$str() {
        return diskBeyondLimit;
    }

    @Override
    public final ActiveMQIOErrorException diskBeyondLimit() {
        ActiveMQIOErrorException result = new ActiveMQIOErrorException(String.format(this.getLoggingLocale(), this.diskBeyondLimit$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionWithIDClosedByManagement$str() {
        return connectionWithIDClosedByManagement;
    }

    @Override
    public final ActiveMQInternalErrorException connectionWithIDClosedByManagement(String ID) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(this._formatMessage(this.connectionWithIDClosedByManagement$str(), ID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String maxConsumerLimitReachedForQueue$str() {
        return maxConsumerLimitReachedForQueue;
    }

    @Override
    public final ActiveMQQueueMaxConsumerLimitReached maxConsumerLimitReachedForQueue(SimpleString address, SimpleString queueName) {
        ActiveMQQueueMaxConsumerLimitReached result = new ActiveMQQueueMaxConsumerLimitReached(this._formatMessage(this.maxConsumerLimitReachedForQueue$str(), address, queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedRoutingTypeForAddress$str() {
        return unexpectedRoutingTypeForAddress;
    }

    @Override
    public final ActiveMQUnexpectedRoutingTypeForAddress unexpectedRoutingTypeForAddress(SimpleString address, RoutingType expectedRoutingType, Set<RoutingType> supportedRoutingTypes) {
        ActiveMQUnexpectedRoutingTypeForAddress result = new ActiveMQUnexpectedRoutingTypeForAddress(this._formatMessage(this.unexpectedRoutingTypeForAddress$str(), address, expectedRoutingType, supportedRoutingTypes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidQueueConfiguration$str() {
        return invalidQueueConfiguration;
    }

    @Override
    public final ActiveMQInvalidQueueConfiguration invalidQueueConfiguration(SimpleString address, SimpleString queueName, String queuePropertyName, Object expectedValue, Object actualValue) {
        ActiveMQInvalidQueueConfiguration result = new ActiveMQInvalidQueueConfiguration(this._formatMessage(this.invalidQueueConfiguration$str(), address, queueName, queuePropertyName, expectedValue, actualValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressDoesNotExist$str() {
        return addressDoesNotExist;
    }

    @Override
    public final ActiveMQAddressDoesNotExistException addressDoesNotExist(SimpleString address) {
        ActiveMQAddressDoesNotExistException result = new ActiveMQAddressDoesNotExistException(this._formatMessage(this.addressDoesNotExist$str(), address));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressAlreadyExists$str() {
        return addressAlreadyExists;
    }

    @Override
    public final ActiveMQAddressExistsException addressAlreadyExists(SimpleString address) {
        ActiveMQAddressExistsException result = new ActiveMQAddressExistsException(this._formatMessage(this.addressAlreadyExists$str(), address));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressHasBindings$str() {
        return addressHasBindings;
    }

    @Override
    public final ActiveMQDeleteAddressException addressHasBindings(SimpleString address) {
        ActiveMQDeleteAddressException result = new ActiveMQDeleteAddressException(this._formatMessage(this.addressHasBindings$str(), address));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMaxConsumers$str() {
        return invalidMaxConsumers;
    }

    @Override
    public final IllegalArgumentException invalidMaxConsumers(String queueName, int value) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidMaxConsumers$str(), queueName, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRoutingTypeForAddress$str() {
        return invalidRoutingTypeForAddress;
    }

    @Override
    public final IllegalArgumentException invalidRoutingTypeForAddress(RoutingType routingType, String address, Set<RoutingType> supportedRoutingTypes) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidRoutingTypeForAddress$str(), routingType, address, supportedRoutingTypes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRoutingType$str() {
        return invalidRoutingType;
    }

    @Override
    public final IllegalArgumentException invalidRoutingType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidRoutingType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRoutingTypeDelete$str() {
        return invalidRoutingTypeDelete;
    }

    @Override
    public final IllegalStateException invalidRoutingTypeDelete(RoutingType routingType, String address) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.invalidRoutingTypeDelete$str(), routingType, address));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMaxConsumersUpdate$str() {
        return invalidMaxConsumersUpdate;
    }

    @Override
    public final IllegalStateException invalidMaxConsumersUpdate(String queueName, int maxConsumers, int consumers) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.invalidMaxConsumersUpdate$str(), queueName, maxConsumers, consumers));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRoutingTypeUpdate$str() {
        return invalidRoutingTypeUpdate;
    }

    @Override
    public final IllegalStateException invalidRoutingTypeUpdate(String queueName, RoutingType routingType, String address, Set<RoutingType> supportedRoutingTypes) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.invalidRoutingTypeUpdate$str(), queueName, routingType, address, supportedRoutingTypes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidDeletionPolicyType$str() {
        return invalidDeletionPolicyType;
    }

    @Override
    public final IllegalArgumentException invalidDeletionPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidDeletionPolicyType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userNoPermissionsQueue$str() {
        return userNoPermissionsQueue;
    }

    @Override
    public final ActiveMQSecurityException userNoPermissionsQueue(String username, CheckType checkType, String squeue, String saddress) {
        ActiveMQSecurityException result = new ActiveMQSecurityException(this._formatMessage(this.userNoPermissionsQueue$str(), new Object[]{username, checkType, squeue, saddress}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notPercentOrMinusOne$str() {
        return notPercentOrMinusOne;
    }

    @Override
    public final IllegalArgumentException notPercentOrMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.notPercentOrMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

