/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.jboss.crypto.digest.DigestCallback;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.InputValidationException;
import org.jboss.security.auth.spi.InputValidator;
import org.jboss.security.auth.spi.SecurityActions;
import org.jboss.security.auth.spi.Util;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultUtil;

public abstract class UsernamePasswordLoginModule
extends AbstractServerLoginModule {
    private static final String HASH_ALGORITHM = "hashAlgorithm";
    private static final String HASH_ENCODING = "hashEncoding";
    private static final String HASH_CHARSET = "hashCharset";
    private static final String HASH_STORE_PASSWORD = "hashStorePassword";
    private static final String HASH_USER_PASSWORD = "hashUserPassword";
    private static final String DIGEST_CALLBACK = "digestCallback";
    private static final String STORE_DIGEST_CALLBACK = "storeDigestCallback";
    private static final String IGNORE_PASSWORD_CASE = "ignorePasswordCase";
    private static final String LEGACY_CREATE_PASSWORD_HASH = "legacyCreatePasswordHash";
    private static final String THROW_VALIDATE_ERROR = "throwValidateError";
    private static final String INPUT_VALIDATOR = "inputValidator";
    private static final String PASS_IS_A1_HASH = "passwordIsA1Hash";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"hashAlgorithm", "hashEncoding", "hashCharset", "hashStorePassword", "hashUserPassword", "digestCallback", "storeDigestCallback", "ignorePasswordCase", "legacyCreatePasswordHash", "throwValidateError", "inputValidator", "passwordIsA1Hash"};
    private Principal identity;
    private char[] credential;
    private String hashAlgorithm = null;
    private String hashCharset = null;
    private String hashEncoding = null;
    private boolean ignorePasswordCase;
    private boolean hashStorePassword;
    private boolean hashUserPassword = true;
    private boolean legacyCreatePasswordHash;
    private boolean throwValidateError = false;
    private Throwable validateError;
    private InputValidator inputValidator = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        this.hashAlgorithm = (String)options.get(HASH_ALGORITHM);
        if (this.hashAlgorithm != null) {
            this.hashEncoding = (String)options.get(HASH_ENCODING);
            if (this.hashEncoding == null) {
                this.hashEncoding = "BASE64";
            }
            this.hashCharset = (String)options.get(HASH_CHARSET);
            PicketBoxLogger.LOGGER.debugPasswordHashing(this.hashAlgorithm, this.hashEncoding, this.hashCharset, (String)options.get(DIGEST_CALLBACK), (String)options.get(STORE_DIGEST_CALLBACK));
        }
        String flag = (String)options.get(IGNORE_PASSWORD_CASE);
        this.ignorePasswordCase = Boolean.valueOf(flag);
        flag = (String)options.get(HASH_STORE_PASSWORD);
        this.hashStorePassword = Boolean.valueOf(flag);
        flag = (String)options.get(HASH_USER_PASSWORD);
        if (flag != null) {
            this.hashUserPassword = Boolean.valueOf(flag);
        }
        if ((flag = (String)options.get(LEGACY_CREATE_PASSWORD_HASH)) != null) {
            this.legacyCreatePasswordHash = Boolean.valueOf(flag);
        }
        if ((flag = (String)options.get(THROW_VALIDATE_ERROR)) != null) {
            this.throwValidateError = Boolean.valueOf(flag);
        }
        if ((flag = (String)options.get(INPUT_VALIDATOR)) != null) {
            try {
                Class<?> validatorClass = SecurityActions.loadClass(flag, this.jbossModuleName);
                this.inputValidator = (InputValidator)validatorClass.newInstance();
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugFailureToInstantiateClass(flag, e);
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    LoginException le = PicketBoxMessages.MESSAGES.failedToCreatePrincipal(e.getLocalizedMessage());
                    le.initCause(e);
                    throw le;
                }
            }
            Object password = this.sharedState.get("javax.security.auth.login.password");
            if (password instanceof char[]) {
                this.credential = (char[])password;
            } else if (password != null) {
                String tmp = password.toString();
                this.credential = tmp.toCharArray();
            }
            return true;
        }
        this.loginOk = false;
        String[] info = this.getUsernameAndPassword();
        String username = info[0];
        String password = info[1];
        if (this.inputValidator != null) {
            try {
                this.inputValidator.validateUsernameAndPassword(username, password);
            }
            catch (InputValidationException ive) {
                throw new FailedLoginException(ive.getLocalizedMessage());
            }
        }
        if (username == null && password == null) {
            this.identity = this.unauthenticatedIdentity;
            PicketBoxLogger.LOGGER.traceUsingUnauthIdentity(this.identity != null ? this.identity.getName() : null);
        }
        if (this.identity == null) {
            String expectedPassword;
            try {
                this.identity = this.createIdentity(username);
            }
            catch (Exception e) {
                LoginException le = PicketBoxMessages.MESSAGES.failedToCreatePrincipal(e.getLocalizedMessage());
                le.initCause(e);
                throw le;
            }
            if (this.hashAlgorithm != null && this.hashUserPassword) {
                password = this.createPasswordHash(username, password, DIGEST_CALLBACK);
            }
            if (SecurityVaultUtil.isVaultFormat(expectedPassword = this.getUsersPassword())) {
                try {
                    expectedPassword = SecurityVaultUtil.getValueAsString(expectedPassword);
                }
                catch (SecurityVaultException e) {
                    LoginException le = PicketBoxMessages.MESSAGES.unableToGetPasswordFromVault();
                    le.initCause(e);
                    throw le;
                }
            }
            if (this.hashAlgorithm != null && this.hashStorePassword) {
                expectedPassword = this.createPasswordHash(username, expectedPassword, STORE_DIGEST_CALLBACK);
            }
            if (!this.validatePassword(password, expectedPassword)) {
                Throwable ex = this.getValidateError();
                FailedLoginException fle = PicketBoxMessages.MESSAGES.invalidPassword();
                PicketBoxLogger.LOGGER.debugBadPasswordForUsername(username);
                if (ex != null && this.throwValidateError) {
                    fle.initCause(ex);
                }
                throw fle;
            }
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", this.identity);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        PicketBoxLogger.LOGGER.traceEndLogin(this.loginOk);
        return true;
    }

    @Override
    protected Principal getIdentity() {
        return this.identity;
    }

    @Override
    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected Object getCredentials() {
        return this.credential;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return username;
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] info = new String[]{null, null};
        if (this.callbackHandler == null) {
            throw PicketBoxMessages.MESSAGES.noCallbackHandlerAvailable();
        }
        NameCallback nc = new NameCallback(PicketBoxMessages.MESSAGES.enterUsernameMessage(), "guest");
        PasswordCallback pc = new PasswordCallback(PicketBoxMessages.MESSAGES.enterPasswordMessage(), false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.credential = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
                pc.clearPassword();
                password = new String(this.credential);
            }
        }
        catch (IOException e) {
            LoginException le = PicketBoxMessages.MESSAGES.failedToInvokeCallbackHandler();
            le.initCause(e);
            throw le;
        }
        catch (UnsupportedCallbackException e) {
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
        info[0] = username;
        info[1] = password;
        return info;
    }

    protected String createPasswordHash(String username, String password, String digestOption) throws LoginException {
        DigestCallback callback = null;
        String callbackClassName = (String)this.options.get(digestOption);
        if (callbackClassName != null) {
            try {
                Class<?> callbackClass = SecurityActions.loadClass(callbackClassName, this.jbossModuleName);
                callback = (DigestCallback)callbackClass.newInstance();
                PicketBoxLogger.LOGGER.traceCreateDigestCallback(callbackClassName);
            }
            catch (Exception e) {
                LoginException le = new LoginException(PicketBoxMessages.MESSAGES.failedToInstantiateClassMessage(Callback.class));
                le.initCause(e);
                throw le;
            }
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            tmp.putAll(this.options);
            tmp.put("javax.security.auth.login.name", username);
            tmp.put("javax.security.auth.login.password", password);
            callback.init(tmp);
            Callback[] callbacks = (Callback[])tmp.get("callbacks");
            if (callbacks != null) {
                try {
                    this.callbackHandler.handle(callbacks);
                }
                catch (IOException e) {
                    LoginException le = PicketBoxMessages.MESSAGES.failedToInvokeCallbackHandler();
                    le.initCause(e);
                    throw le;
                }
                catch (UnsupportedCallbackException e) {
                    LoginException le = PicketBoxMessages.MESSAGES.failedToInvokeCallbackHandler();
                    le.initCause(e);
                    throw le;
                }
            }
        }
        String passwordHash = Util.createPasswordHash(this.hashAlgorithm, this.hashEncoding, this.hashCharset, username, password, callback);
        return passwordHash;
    }

    protected Throwable getValidateError() {
        return this.validateError;
    }

    protected void setValidateError(Throwable validateError) {
        this.validateError = validateError;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (inputPassword == null || expectedPassword == null) {
            return false;
        }
        boolean valid = false;
        valid = this.ignorePasswordCase ? inputPassword.equalsIgnoreCase(expectedPassword) : inputPassword.equals(expectedPassword);
        return valid;
    }

    protected abstract String getUsersPassword() throws LoginException;

    protected void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

