/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.auth;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityUtil;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.jboss.security.plugins.ClassLoaderLocatorFactory;
import org.jboss.security.plugins.auth.SubjectActions;

public class JaasSecurityManagerBase
implements SubjectSecurityManager,
RealmMapping {
    private String securityDomain;
    private CallbackHandler handler;
    private transient Method setSecurityInfo;
    private boolean deepCopySubjectOption = false;
    private AuthorizationManager authorizationManager;

    public JaasSecurityManagerBase() {
        this("other", new JBossCallbackHandler());
    }

    public JaasSecurityManagerBase(String securityDomain, CallbackHandler handler) {
        this.securityDomain = SecurityUtil.unprefixSecurityDomain(securityDomain);
        this.handler = handler;
        String categoryName = this.getClass().getName() + '.' + securityDomain;
        Class[] sig = new Class[]{Principal.class, Object.class};
        try {
            this.setSecurityInfo = handler.getClass().getMethod("setSecurityInfo", sig);
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, PicketBoxMessages.MESSAGES.unableToFindSetSecurityInfoMessage());
        }
    }

    public void setDeepCopySubjectOption(Boolean flag) {
        this.deepCopySubjectOption = flag;
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    @Override
    public Subject getActiveSubject() {
        Subject subj = null;
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        if (sc != null) {
            subj = sc.getUtil().getSubject();
        }
        return subj;
    }

    @Override
    public boolean isValid(Principal principal, Object credential) {
        return this.isValid(principal, credential, null);
    }

    @Override
    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        PicketBoxLogger.LOGGER.traceBeginIsValid(principal, null);
        boolean isValid = false;
        if (!isValid) {
            isValid = this.authenticate(principal, credential, activeSubject);
        }
        PicketBoxLogger.LOGGER.traceEndIsValid(isValid);
        return isValid;
    }

    @Override
    public Principal getPrincipal(Principal principal) {
        return principal;
    }

    @Override
    public boolean doesUserHaveRole(Principal principal, Set<Principal> rolePrincipals) {
        if (this.authorizationManager == null) {
            this.authorizationManager = SecurityUtil.getAuthorizationManager(this.securityDomain, "java:jboss/jaas/");
        }
        if (this.authorizationManager == null) {
            PicketBoxLogger.LOGGER.debugNullAuthorizationManager(this.securityDomain);
            return false;
        }
        return this.authorizationManager.doesUserHaveRole(principal, rolePrincipals);
    }

    @Override
    public Set<Principal> getUserRoles(Principal principal) {
        if (this.authorizationManager == null) {
            this.authorizationManager = SecurityUtil.getAuthorizationManager(this.securityDomain, "java:jboss/jaas/");
        }
        if (this.authorizationManager == null) {
            PicketBoxLogger.LOGGER.debugNullAuthorizationManager(this.securityDomain);
            return null;
        }
        return this.authorizationManager.getUserRoles(principal);
    }

    @Override
    public Principal getTargetPrincipal(Principal anotherDomainPrincipal, Map<String, Object> contextMap) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticate(Principal principal, Object credential, Subject theSubject) {
        BaseAuthenticationInfo authInfo;
        String jbossModuleName;
        ApplicationPolicy theAppPolicy = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
        if (theAppPolicy != null && (jbossModuleName = (authInfo = theAppPolicy.getAuthenticationInfo()).getJBossModuleName()) != null) {
            ClassLoader newTCCL;
            ClassLoader currentTccl = SubjectActions.getContextClassLoader();
            ClassLoaderLocator theCLL = ClassLoaderLocatorFactory.get();
            if (theCLL != null && (newTCCL = theCLL.get(jbossModuleName)) != null) {
                try {
                    SubjectActions.setContextClassLoader(newTCCL);
                    boolean bl = this.proceedWithJaasLogin(principal, credential, theSubject);
                    return bl;
                }
                finally {
                    SubjectActions.setContextClassLoader(currentTccl);
                }
            }
        }
        return this.proceedWithJaasLogin(principal, credential, theSubject);
    }

    private boolean proceedWithJaasLogin(Principal principal, Object credential, Subject theSubject) {
        Subject subject = null;
        boolean authenticated = false;
        LoginException authException = null;
        try {
            LoginContext lc = this.defaultLogin(principal, credential);
            subject = lc.getSubject();
            if (subject != null) {
                if (theSubject != null) {
                    SubjectActions.copySubject(subject, theSubject, false, this.deepCopySubjectOption);
                } else {
                    theSubject = subject;
                }
                authenticated = true;
            }
        }
        catch (LoginException e) {
            if (principal != null && principal.getName() != null) {
                PicketBoxLogger.LOGGER.debugFailedLogin(e);
            }
            authException = e;
        }
        SubjectActions.setContextInfo("org.jboss.security.exception", authException);
        return authenticated;
    }

    private LoginContext defaultLogin(Principal principal, Object credential) throws LoginException {
        Object[] securityInfo = new Object[]{principal, credential};
        CallbackHandler theHandler = null;
        try {
            theHandler = (CallbackHandler)this.handler.getClass().newInstance();
            this.setSecurityInfo.invoke((Object)theHandler, securityInfo);
        }
        catch (Throwable e) {
            LoginException le = new LoginException(PicketBoxMessages.MESSAGES.unableToFindSetSecurityInfoMessage());
            le.initCause(e);
            throw le;
        }
        Subject subject = new Subject();
        LoginContext lc = null;
        PicketBoxLogger.LOGGER.traceDefaultLoginPrincipal(principal);
        lc = SubjectActions.createLoginContext(this.securityDomain, subject, theHandler);
        lc.login();
        if (PicketBoxLogger.LOGGER.isDebugEnabled()) {
            PicketBoxLogger.LOGGER.traceDefaultLoginSubject(lc.toString(), SubjectActions.toString(subject));
        }
        return lc;
    }

    @Override
    public void logout(Principal principal, Subject subject) {
        if (subject == null) {
            subject = new Subject();
        }
        LoginContext context = null;
        Object[] securityInfo = new Object[]{principal, null};
        CallbackHandler theHandler = null;
        try {
            theHandler = (CallbackHandler)this.handler.getClass().newInstance();
            this.setSecurityInfo.invoke((Object)theHandler, securityInfo);
            context = SubjectActions.createLoginContext(this.securityDomain, subject, theHandler);
        }
        catch (Throwable e) {
            LoginException le = new LoginException(PicketBoxMessages.MESSAGES.unableToInitializeLoginContext(e));
            le.initCause(e);
            SubjectActions.setContextInfo("org.jboss.security.exception", le);
            return;
        }
        try {
            context.logout();
            if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
                PicketBoxLogger.LOGGER.traceLogoutSubject(context.toString(), SubjectActions.toString(subject));
            }
        }
        catch (LoginException le) {
            SubjectActions.setContextInfo("org.jboss.security.exception", le);
        }
    }
}

