/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.legacy.test.controller.subsystem_18_0_0;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionRegistryType;
import org.jboss.as.controller.operations.global.GlobalNotifications;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.resources.ServerDeploymentResourceDefinition;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.AdditionalInitializationUtil;
import org.jboss.as.subsystem.test.ControllerInitializer;
import org.jboss.dmr.ModelNode;
import org.jboss.vfs.VirtualFile;

public class TestModelControllerService18_0_0
extends ModelTestModelControllerService {
    private final Extension mainExtension;
    private final AdditionalInitialization additionalInit;
    private final ControllerInitializer controllerInitializer;
    private final ExtensionRegistry extensionRegistry;
    private final RunningModeControl runningModeControl;
    private final ContentRepository contentRepository = new MockContentRepository();
    private final boolean registerTransformers;

    TestModelControllerService18_0_0(ProcessType processType, Extension mainExtension, ControllerInitializer controllerInitializer, AdditionalInitialization additionalInit, RunningModeControl runningModeControl, ExtensionRegistry extensionRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, boolean registerTransformers, CapabilityRegistry capabilityRegistry) {
        super(processType, runningModeControl, extensionRegistry.getTransformerRegistry(), persister, validateOpsFilter, (ResourceDefinition)new SimpleResourceDefinition(null, (ResourceDescriptionResolver)new NonResolvingResourceDescriptionResolver()), new ControlledProcessState(true), capabilityRegistry, ModelTestModelControllerService.Controller18x.INSTANCE);
        this.mainExtension = mainExtension;
        this.additionalInit = additionalInit;
        this.controllerInitializer = controllerInitializer;
        this.extensionRegistry = extensionRegistry;
        this.runningModeControl = runningModeControl;
        this.registerTransformers = registerTransformers;
    }

    protected void initExtraModel(ManagementModel managementModel) {
        Resource rootResource = managementModel.getRootResource();
        ManagementResourceRegistration rootRegistration = managementModel.getRootResourceRegistration();
        rootResource.getModel().get("subsystem");
        ManagementResourceRegistration deployments = rootRegistration.registerSubModel((ResourceDefinition)ServerDeploymentResourceDefinition.create((ContentRepository)this.contentRepository, null, (ServerEnvironment)this.getServerEnvironment()));
        AdditionalInitializationUtil.doExtraInitialization(this.additionalInit, this.controllerInitializer, this.extensionRegistry, managementModel, this);
    }

    protected void initModel(ManagementModel managementModel, Resource modelControllerResource) {
        super.initModel(managementModel, modelControllerResource);
    }

    protected void initCoreModel(ManagementModel managementModel, Resource modelControllerResource) {
        super.initCoreModel(managementModel, modelControllerResource);
        GlobalNotifications.registerGlobalNotifications((ManagementResourceRegistration)managementModel.getRootResourceRegistration(), (ProcessType)this.processType);
    }

    protected void preBoot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) {
        this.mainExtension.initialize(this.extensionRegistry.getExtensionContext("Test", this.getRootRegistration(), ExtensionRegistryType.SERVER));
    }

    protected void postBoot() {
        DeployerChainAddHandler.INSTANCE.clearDeployerMap();
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
        file.delete();
    }

    public ServerEnvironment getServerEnvironment() {
        Properties props = new Properties();
        File home = new File("target/jbossas");
        this.delete(home);
        home.mkdir();
        props.put("jboss.home.dir", home.getAbsolutePath());
        File standalone = new File(home, "standalone");
        standalone.mkdir();
        props.put("jboss.server.base.dir", standalone.getAbsolutePath());
        File configuration = new File(standalone, "configuration");
        configuration.mkdir();
        props.put("jboss.server.config.dir", configuration.getAbsolutePath());
        File xml = new File(configuration, "standalone.xml");
        try {
            xml.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        props.put("jboss.server.default.config", "standalone.xml");
        return new ServerEnvironment(null, props, new HashMap(), "standalone.xml", null, ServerEnvironment.LaunchType.STANDALONE, this.runningModeControl.getRunningMode(), null);
    }

    private static class MockContentRepository
    implements ContentRepository {
        private MockContentRepository() {
        }

        public byte[] addContent(InputStream stream) throws IOException {
            return null;
        }

        public VirtualFile getContent(byte[] hash) {
            return null;
        }

        public boolean hasContent(byte[] hash) {
            return false;
        }

        public boolean syncContent(ContentReference reference) {
            return false;
        }

        public void removeContent(ContentReference reference) {
        }

        public void addContentReference(ContentReference reference) {
        }

        public Map<String, Set<String>> cleanObsoleteContent() {
            return null;
        }
    }
}

