/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.RealmReadinessFilter;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.dmr.ModelNode;

public class DmrFailureReadinessFilter
extends RealmReadinessFilter {
    private final String redirectTo;

    DmrFailureReadinessFilter(SecurityRealm securityRealm, String redirectTo) {
        super(securityRealm);
        this.redirectTo = redirectTo;
    }

    @Override
    void rejectRequest(HttpExchange exchange) throws IOException {
        ModelNode rejection = new ModelNode();
        rejection.get("outcome").set("failed");
        rejection.get("failure-description").set(HttpServerMessages.MESSAGES.realmNotReadyMessage(DomainUtil.constructUrl(exchange, this.redirectTo)));
        rejection.get("rolled-back").set(Boolean.TRUE.toString());
        DomainUtil.writeResponse(exchange, false, true, rejection, 403, false);
    }

    public String description() {
        return HttpServerMessages.MESSAGES.dmrFailureReadinessFilter();
    }
}

