/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.SecurityActions;
import org.jboss.as.domain.http.server.multipart.BoundaryDelimitedInputStream;
import org.jboss.as.domain.http.server.multipart.MimeHeaderParser;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.dmr.ModelNode;

class DomainApiUploadHandler
implements HttpHandler {
    private static final String OPERATION = "operation";
    private static final int BUFFER_SIZE = 8192;
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final Pattern MULTIPART_FD_BOUNDARY = Pattern.compile("^multipart/form-data.*;\\s*boundary=(.*)$");
    private final File tempFileLocation = new File(SecurityActions.getProperty("java.io.tmpdir"));
    private final ModelController modelController;

    public DomainApiUploadHandler(ModelController modelController) {
        this.modelController = modelController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpExchange exchange) throws IOException {
        ArrayList<File> tempFiles = new ArrayList<File>();
        ModelNode operation = new ModelNode();
        OperationBuilder builder = new OperationBuilder(operation);
        try {
            boolean encode = this.processRequest(exchange, operation, builder, tempFiles);
            operation.get(new String[]{"operation-headers", "access-mechanism"}).set(AccessMechanism.HTTP.toString());
            ModelNode response = this.modelController.execute(operation, OperationMessageHandler.DISCARD, ModelController.OperationTransactionControl.COMMIT, (OperationAttachments)builder.build());
            DomainUtil.writeResponse(exchange, false, false, response, 200, encode);
        }
        catch (Throwable t) {
            this.sendError(exchange, t);
        }
        finally {
            DomainApiUploadHandler.safeClose(exchange.getRequestBody());
            for (File file : tempFiles) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processRequest(HttpExchange exchange, ModelNode operation, OperationBuilder builder, List<File> tempFiles) throws IOException {
        String contentType = exchange.getRequestHeaders().getFirst("Content-Type");
        byte[] buffer = new byte[8192];
        String boundary = DomainApiUploadHandler.resolveBoundary(contentType);
        BoundaryDelimitedInputStream stream = new BoundaryDelimitedInputStream(exchange.getRequestBody(), boundary.getBytes(US_ASCII));
        DomainApiUploadHandler.drain(stream, buffer);
        stream.setBoundary(("\r\n" + boundary).getBytes(US_ASCII));
        boolean encode = false;
        while (!stream.isOuterStreamClosed()) {
            MimeHeaderParser.ParseResult result = MimeHeaderParser.parseHeaders(stream);
            if (result.eof()) continue;
            Headers partHeaders = result.headers();
            String disposition = partHeaders.getFirst("Content-Disposition");
            if (disposition != null && disposition.startsWith("form-data")) {
                String name = DomainApiUploadHandler.getValueFromHeader(disposition, "name");
                String fileName = DomainApiUploadHandler.getValueFromHeader(disposition, "filename");
                if (OPERATION.equals(name)) {
                    encode = DomainApiUploadHandler.processOperation(operation, partHeaders, stream, buffer);
                    continue;
                }
                if (fileName != null) {
                    File file = File.createTempFile("http", "upload", this.tempFileLocation);
                    tempFiles.add(file);
                    FileOutputStream os = new FileOutputStream(file);
                    try {
                        DomainApiUploadHandler.copyStream(stream, os, buffer);
                        ((OutputStream)os).close();
                        builder.addFileAsAttachment(file);
                        continue;
                    }
                    finally {
                        DomainApiUploadHandler.safeClose(os);
                        continue;
                    }
                }
                DomainApiUploadHandler.drain(stream, buffer);
                continue;
            }
            throw HttpServerMessages.MESSAGES.unsupportedContentDisposition(disposition);
        }
        return encode;
    }

    private static boolean processOperation(ModelNode operation, Headers partHeaders, InputStream stream, byte[] buffer) throws IOException {
        String contentType = partHeaders.getFirst("Content-Type");
        if ("application/dmr-encoded".equals(contentType)) {
            operation.set(ModelNode.fromBase64((InputStream)new Base64InputStreamWrapper(stream)));
            return true;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DomainApiUploadHandler.copyStream(stream, os, buffer);
        Charset charset = DomainApiUploadHandler.getCharset(contentType);
        operation.set(ModelNode.fromJSONString((String)new String(os.toByteArray(), charset)));
        return false;
    }

    private static void copyStream(InputStream is, OutputStream os, byte[] buffer) throws IOException {
        int cnt;
        while ((cnt = is.read(buffer)) != -1) {
            os.write(buffer, 0, cnt);
        }
    }

    private static Charset getCharset(String contentType) {
        String cs;
        Charset charset = US_ASCII;
        if (contentType != null && (cs = DomainApiUploadHandler.getValueFromHeader(contentType, "charset")) != null) {
            charset = Charset.forName(cs);
        }
        return charset;
    }

    private void sendError(HttpExchange http, Throwable t) throws IOException {
        ModelNode response = new ModelNode();
        response.set(t.getMessage());
        DomainUtil.writeResponse(http, false, true, response, 500, false);
    }

    public static String getValueFromHeader(String header, String key) {
        char c;
        int end;
        int pos = header.indexOf(key + '=');
        if (pos == -1) {
            return null;
        }
        int start = pos + key.length() + 1;
        if (header.charAt(start) == '\"') {
            char c2;
            int end2;
            for (end2 = ++start; end2 < header.length() && (c2 = header.charAt(end2)) != '\"'; ++end2) {
            }
            return header.substring(start, end2);
        }
        for (end = start; end < header.length() && (c = header.charAt(end)) != ' ' && c != '\t'; ++end) {
        }
        return header.substring(start, end);
    }

    static String resolveBoundary(String contentType) {
        if (contentType == null) {
            throw HttpServerMessages.MESSAGES.invalidContentType();
        }
        Matcher matcher = MULTIPART_FD_BOUNDARY.matcher(contentType);
        if (!matcher.matches()) {
            throw HttpServerMessages.MESSAGES.invalidContentType(contentType);
        }
        return "--" + matcher.group(1);
    }

    static void drain(InputStream is, byte[] buffer) throws IOException {
        while (is.read(buffer) != -1) {
        }
    }

    static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                HttpServerLogger.ROOT_LOGGER.debugf(e, "failed to close stream", new Object[0]);
            }
        }
    }

    static class Base64InputStreamWrapper
    extends FilterInputStream {
        Base64InputStreamWrapper(InputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

