/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.ha.ManagementHelper;
import org.wildfly.extension.messaging.activemq.ha.ScaleDownAttributes;

public class ReplicationSlaveDefinition
extends PersistentResourceDefinition {
    public static final Collection<AttributeDefinition> ATTRIBUTES;
    public static final ReplicationSlaveDefinition INSTANCE;
    public static final ReplicationSlaveDefinition CONFIGURATION_INSTANCE;

    private ReplicationSlaveDefinition(PathElement path, boolean allowSibling) {
        super(path, MessagingExtension.getResourceDescriptionResolver("ha-policy"), (OperationStepHandler)ManagementHelper.createAddOperation(path.getKey(), allowSibling, ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ActiveMQReloadRequiredHandlers.WriteAttributeHandler writeAttribute = new ActiveMQReloadRequiredHandlers.WriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeAttribute);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static HAPolicyConfiguration buildConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode groupName;
        ReplicaPolicyConfiguration haPolicyConfiguration = new ReplicaPolicyConfiguration().setAllowFailBack(HAAttributes.ALLOW_FAILBACK.resolveModelAttribute(context, model).asBoolean()).setInitialReplicationSyncTimeout(HAAttributes.INITIAL_REPLICATION_SYNC_TIMEOUT.resolveModelAttribute(context, model).asLong()).setMaxSavedReplicatedJournalsSize(HAAttributes.MAX_SAVED_REPLICATED_JOURNAL_SIZE.resolveModelAttribute(context, model).asInt()).setScaleDownConfiguration(ScaleDownAttributes.addScaleDownConfiguration(context, model)).setRestartBackup(HAAttributes.RESTART_BACKUP.resolveModelAttribute(context, model).asBoolean());
        ModelNode clusterName = HAAttributes.CLUSTER_NAME.resolveModelAttribute(context, model);
        if (clusterName.isDefined()) {
            haPolicyConfiguration.setClusterName(clusterName.asString());
        }
        if ((groupName = HAAttributes.GROUP_NAME.resolveModelAttribute(context, model)).isDefined()) {
            haPolicyConfiguration.setGroupName(groupName.asString());
        }
        return haPolicyConfiguration;
    }

    static {
        ArrayList<Object> attributes = new ArrayList<Object>();
        attributes.add(HAAttributes.CLUSTER_NAME);
        attributes.add(HAAttributes.GROUP_NAME);
        attributes.add(HAAttributes.ALLOW_FAILBACK);
        attributes.add(HAAttributes.INITIAL_REPLICATION_SYNC_TIMEOUT);
        attributes.add(HAAttributes.MAX_SAVED_REPLICATED_JOURNAL_SIZE);
        attributes.add(HAAttributes.RESTART_BACKUP);
        attributes.addAll(ScaleDownAttributes.SCALE_DOWN_ATTRIBUTES);
        ATTRIBUTES = Collections.unmodifiableCollection(attributes);
        INSTANCE = new ReplicationSlaveDefinition(MessagingExtension.REPLICATION_SLAVE_PATH, false);
        CONFIGURATION_INSTANCE = new ReplicationSlaveDefinition(MessagingExtension.CONFIGURATION_SLAVE_PATH, true);
    }
}

