/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting.management;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementChannelOpenListenerService;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.Option;
import org.xnio.OptionMap;

public final class ManagementRemotingServices
extends RemotingServices {
    public static final ServiceName MANAGEMENT_ENDPOINT = RemotingServices.REMOTING_BASE.append(new String[]{"endpoint", "management"});
    public static final ServiceName SHUTDOWN_EXECUTOR_NAME = MANAGEMENT_ENDPOINT.append(new String[]{"shutdown", "executor"});
    public static final String MANAGEMENT_CHANNEL = "management";
    public static final String DOMAIN_CHANNEL = "domain";
    public static final String SERVER_CHANNEL = "server";
    public static final String MANAGEMENT_CONNECTOR = "management";

    private ManagementRemotingServices() {
    }

    public static void installDomainConnectorServices(ServiceTarget serviceTarget, ServiceName endpointName, ServiceName networkInterfaceBinding, int port, String securityRealm, OptionMap options, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceName serverCallbackService = ServiceName.JBOSS.append(new String[]{"host", "controller", "server-inventory", "callback"});
        ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{SERVER_CHANNEL, "path", "jboss.domain.temp.dir"});
        ManagementRemotingServices.installSecurityServices(serviceTarget, "management", securityRealm, serverCallbackService, tmpDirPath, verificationHandler, newControllers);
        ManagementRemotingServices.installConnectorServicesForNetworkInterfaceBinding(serviceTarget, endpointName, "management", networkInterfaceBinding, port, options, verificationHandler, newControllers);
    }

    public static void installManagementChannelOpenListenerService(ServiceTarget serviceTarget, ServiceName endpointName, String channelName, ServiceName operationHandlerName, OptionMap options, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, boolean onDemand) {
        ManagementChannelOpenListenerService channelOpenListenerService = new ManagementChannelOpenListenerService(channelName, options);
        ServiceBuilder builder = serviceTarget.addService(channelOpenListenerService.getServiceName(endpointName), (Service)channelOpenListenerService).addDependency(endpointName, Endpoint.class, channelOpenListenerService.getEndpointInjector()).addDependency(operationHandlerName, ManagementChannelInitialization.class, channelOpenListenerService.getOperationHandlerInjector()).addDependency(ManagementChannelRegistryService.SERVICE_NAME, ManagementChannelRegistryService.class, channelOpenListenerService.getRegistry()).addDependency(SHUTDOWN_EXECUTOR_NAME, ExecutorService.class, channelOpenListenerService.getExecutorServiceInjectedValue()).setInitialMode(onDemand ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.ACTIVE);
        ManagementRemotingServices.addController(newControllers, verificationHandler, builder);
    }

    public static void removeManagementChannelOpenListenerService(OperationContext context, ServiceName endpointName, String channelName) {
        context.removeService(RemotingServices.channelServiceName(endpointName, channelName));
    }

    public static void installManagementChannelServices(ServiceTarget serviceTarget, ServiceName endpointName, AbstractModelControllerOperationHandlerFactoryService operationHandlerService, ServiceName modelControllerName, String channelName, ServiceName executorServiceName, ServiceName scheduledExecutorServiceName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        OptionMap options = OptionMap.create((Option)RemotingOptions.RECEIVE_WINDOW_SIZE, (Object)32768, (Option)RemotingOptions.TRANSMIT_WINDOW_SIZE, (Object)32768);
        ServiceName operationHandlerName = endpointName.append(new String[]{channelName}).append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
        ServiceBuilder builder = serviceTarget.addService(operationHandlerName, (Service)operationHandlerService).addDependency(modelControllerName, ModelController.class, (Injector)operationHandlerService.getModelControllerInjector()).addDependency(executorServiceName, ExecutorService.class, (Injector)operationHandlerService.getExecutorInjector()).addDependency(scheduledExecutorServiceName, ScheduledExecutorService.class, (Injector)operationHandlerService.getScheduledExecutorInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        ManagementRemotingServices.addController(newControllers, verificationHandler, builder);
        ManagementRemotingServices.installManagementChannelOpenListenerService(serviceTarget, endpointName, channelName, operationHandlerName, options, verificationHandler, newControllers, false);
    }

    public static void removeManagementChannelServices(OperationContext context, ServiceName endpointName, String channelName) {
        ManagementRemotingServices.removeManagementChannelOpenListenerService(context, endpointName, channelName);
        ServiceName operationHandlerName = endpointName.append(new String[]{channelName}).append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
        context.removeService(operationHandlerName);
    }
}

