/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import java.text.DateFormat;
import java.util.Date;
import javax.json.JsonObject;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.core.messagecounter.MessageCounter;
import org.apache.activemq.artemis.utils.JsonLoader;

public final class MessageCounterInfo {
    private final String name;
    private final String subscription;
    private final boolean durable;
    private final long count;
    private final long countDelta;
    private final int depth;
    private final int depthDelta;
    private final String lastAddTimestamp;
    private final String udpateTimestamp;

    public static String toJSon(MessageCounter counter) throws Exception {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
        String lastAddTimestamp = dateFormat.format(new Date(counter.getLastAddedMessageTime()));
        String updateTimestamp = dateFormat.format(new Date(counter.getLastUpdate()));
        return JsonLoader.createObjectBuilder().add("destinationName", JsonUtil.nullSafe((String)counter.getDestinationName())).add("destinationSubscription", JsonUtil.nullSafe((String)counter.getDestinationSubscription())).add("destinationDurable", counter.isDestinationDurable()).add("count", counter.getCount()).add("countDelta", counter.getCountDelta()).add("messageCount", counter.getMessageCount()).add("messageCountDelta", counter.getMessageCountDelta()).add("lastAddTimestamp", lastAddTimestamp).add("updateTimestamp", updateTimestamp).build().toString();
    }

    public static MessageCounterInfo fromJSON(String jsonString) throws Exception {
        JsonObject data = JsonUtil.readJsonObject((String)jsonString);
        String name = data.getString("destinationName");
        String subscription = data.getString("destinationSubscription", null);
        boolean durable = data.getBoolean("destinationDurable");
        long count = data.getJsonNumber("count").longValue();
        long countDelta = data.getJsonNumber("countDelta").longValue();
        int depth = data.getInt("messageCount");
        int depthDelta = data.getInt("messageCountDelta");
        String lastAddTimestamp = data.getString("lastAddTimestamp");
        String updateTimestamp = data.getString("updateTimestamp");
        return new MessageCounterInfo(name, subscription, durable, count, countDelta, depth, depthDelta, lastAddTimestamp, updateTimestamp);
    }

    public MessageCounterInfo(String name, String subscription, boolean durable, long count, long countDelta, int depth, int depthDelta, String lastAddTimestamp, String udpateTimestamp) {
        this.name = name;
        this.subscription = subscription;
        this.durable = durable;
        this.count = count;
        this.countDelta = countDelta;
        this.depth = depth;
        this.depthDelta = depthDelta;
        this.lastAddTimestamp = lastAddTimestamp;
        this.udpateTimestamp = udpateTimestamp;
    }

    public String getName() {
        return this.name;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public long getCount() {
        return this.count;
    }

    public long getCountDelta() {
        return this.countDelta;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getDepthDelta() {
        return this.depthDelta;
    }

    public String getLastAddTimestamp() {
        return this.lastAddTimestamp;
    }

    public String getUdpateTimestamp() {
        return this.udpateTimestamp;
    }
}

