/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Tree<T> {
    private final T value;
    private final List<Tree<T>> children = new ArrayList<Tree<T>>();

    public Tree() {
        this(null);
    }

    public Tree(T value) {
        this.value = value;
    }

    public Tree<T> addChild(Tree<T> child) {
        this.children.add(child);
        return child;
    }

    public Tree<T> addChild(T child) {
        return this.addChild((T)new Tree<T>(child));
    }

    public T value() {
        return this.value;
    }

    public List<Tree<T>> children() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isRoot() {
        return this.value == null;
    }

    public List<List<T>> pathsToValue(Function<T, Boolean> pred) {
        return this.pathsToValue(false, pred);
    }

    public List<List<T>> pathsToValue(boolean includeValue, Function<T, Boolean> pred) {
        ArrayList<List<T>> paths = new ArrayList<List<T>>();
        if (!this.isRoot() && pred.apply(this.value).booleanValue()) {
            ArrayList<T> path = new ArrayList<T>();
            if (includeValue) {
                path.add(this.value);
            }
            paths.add(path);
        }
        this.children().forEach(c -> {
            List<List<List>> childPaths = c.pathsToValue(includeValue, pred);
            if (!childPaths.isEmpty() && !this.isRoot()) {
                childPaths.forEach(p -> p.add(0, this.value));
            }
            paths.addAll(childPaths);
        });
        return paths;
    }

    public <V> V reduce(V accum, BiFunction<V, T, V> s) {
        Object ret = accum;
        try {
            if (!this.isRoot()) {
                ret = s.apply(ret, this.value);
            }
            for (Tree<V> tree : this.children) {
                ret = tree.reduce(ret, s);
            }
        }
        catch (ReduceComplete e) {
            ret = e.result;
        }
        return ret;
    }

    public String toString() {
        return "<value=" + this.value + ", children=" + this.children + ">";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tree)) {
            return false;
        }
        Tree that = (Tree)obj;
        return !(this.isRoot() && !that.isRoot() || !this.isRoot() && that.isRoot() || !this.isRoot() && !this.value.equals(that.value) || !this.children.equals(that.children));
    }

    public int hashCode() {
        return (this.isRoot() ? 0 : this.value.hashCode()) + this.children.hashCode();
    }

    public static void reduceComplete(Object result) {
        throw new ReduceComplete(result);
    }

    private static class ReduceComplete
    extends RuntimeException {
        public final Object result;

        ReduceComplete(Object result) {
            this.result = result;
        }
    }
}

