/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.domain.management.LegacyConfigurationChangeResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionPropertyResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.as.domain.management.security.AdvancedUserSearchResourceDefintion;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.BaseLdapUserSearchResource;
import org.jboss.as.domain.management.security.GroupToPrincipalResourceDefinition;
import org.jboss.as.domain.management.security.JaasAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.KerberosAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.domain.management.security.KeytabResourceDefinition;
import org.jboss.as.domain.management.security.LdapAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LdapAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.LdapCacheResourceDefinition;
import org.jboss.as.domain.management.security.LocalAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PrincipalToGroupResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PropertyResourceDefinition;
import org.jboss.as.domain.management.security.SSLServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecretServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.domain.management.security.UserResourceDefinition;
import org.jboss.as.domain.management.security.UserSearchResourceDefintion;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;

final class ManagementXml_4
implements ManagementXml {
    private final Namespace namespace;
    private final ManagementXmlDelegate delegate;

    ManagementXml_4(Namespace namespace, ManagementXmlDelegate delegate) {
        this.namespace = namespace;
        this.delegate = delegate;
    }

    @Override
    public void parseManagement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        int securityRealmsCount = 0;
        int connectionsCount = 0;
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: {
                    if (++securityRealmsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseSecurityRealms(reader, managementAddress, list)) continue block8;
                    this.parseSecurityRealms(reader, managementAddress, list);
                    continue block8;
                }
                case OUTBOUND_CONNECTIONS: {
                    if (++connectionsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseOutboundConnections(reader, managementAddress, list)) continue block8;
                    this.parseOutboundConnections(reader, managementAddress, list);
                    continue block8;
                }
                case MANAGEMENT_INTERFACES: {
                    if (++managementInterfacesCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseManagementInterfaces(reader, managementAddress, list)) continue block8;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case AUDIT_LOG: {
                    if (this.delegate.parseAuditLog(reader, managementAddress, list)) continue block8;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case ACCESS_CONTROL: {
                    if (this.delegate.parseAccessControl(reader, managementAddress, list)) continue block8;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case CONFIGURATION_CHANGES: {
                    this.parseConfigurationChanges(reader, managementAddress, list);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }

    private void parseConfigurationChanges(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        PathAddress operationAddress = PathAddress.pathAddress((ModelNode)address);
        operationAddress = operationAddress.append(new PathElement[]{LegacyConfigurationChangeResourceDefinition.PATH});
        ModelNode add = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathAddress)operationAddress, (PathElement[])new PathElement[0]));
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_HISTORY: {
                    LegacyConfigurationChangeResourceDefinition.MAX_HISTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(add);
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseOutboundConnections(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case LDAP: {
                    this.parseLdapConnection(reader, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapConnection(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        ModelNode connectionAddress = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    connectionAddress = address.clone().add("ldap-connection", value);
                    add.get("address").set(connectionAddress);
                    continue block13;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case SECURITY_REALM: {
                    LdapConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case REFERRALS: {
                    LdapConnectionResourceDefinition.REFERRALS.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case HANDLES_REFERRALS_FOR: {
                    for (String url : reader.getListAttributeValue(i)) {
                        LdapConnectionResourceDefinition.HANDLES_REFERRALS_FOR.parseAndAddParameterElement(url, add, (XMLStreamReader)reader);
                    }
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean propertiesFound = false;
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    if (propertiesFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    propertiesFound = true;
                    this.parseLdapConnectionProperties(reader, connectionAddress, list);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapConnectionProperties(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
                    ModelNode add = new ModelNode();
                    add.get("operation").set("add");
                    int count = reader.getAttributeCount();
                    block8: for (int i = 0; i < count; ++i) {
                        String value = reader.getAttributeValue(i);
                        if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                        Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                        required.remove(attribute);
                        switch (attribute) {
                            case NAME: {
                                add.get("address").set(address.clone()).add("property", value);
                                continue block8;
                            }
                            case VALUE: {
                                LdapConnectionPropertyResourceDefinition.VALUE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (required.size() > 0) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    list.add(add);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealms(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALM: {
                    this.parseSecurityRealm(reader, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealm(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_INS: {
                    this.parsePlugIns(reader, realmAddress, list);
                    continue block6;
                }
                case SERVER_IDENTITIES: {
                    this.parseServerIdentities(reader, realmAddress, list);
                    continue block6;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, realmAddress, list);
                    continue block6;
                }
                case AUTHORIZATION: {
                    this.parseAuthorization(reader, add, list);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePlugIns(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_IN: {
                    ModelNode plugIn = new ModelNode();
                    plugIn.get("operation").set("add");
                    String moduleValue = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.MODULE.getLocalName());
                    ModelNode newAddress = realmAddress.clone();
                    newAddress.add("plug-in", moduleValue);
                    plugIn.get("address").set(newAddress);
                    list.add(plugIn);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerIdentities(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECRET: {
                    this.parseSecret(reader, realmAddress, list);
                    continue block5;
                }
                case SSL: {
                    this.parseSSL(reader, realmAddress, list);
                    continue block5;
                }
                case KERBEROS: {
                    this.parseKerberosIdentity(reader, realmAddress, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecret(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode secret = new ModelNode();
        secret.get("operation").set("add");
        secret.get("address").set(realmAddress).add("server-identity", "secret");
        String secretValue = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
        SecretServerIdentityResourceDefinition.VALUE.parseAndSetParameter(secretValue, secret, (XMLStreamReader)reader);
        list.add(secret);
    }

    private void parseSSL(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.get("operation").set("add");
        ssl.get("address").set(realmAddress).add("server-identity", "ssl");
        list.add(ssl);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROTOCOL: {
                    SSLServerIdentityResourceDefinition.PROTOCOL.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ENGINE: {
                    this.parseEngine(reader, ssl);
                    continue block8;
                }
                case KEYSTORE: {
                    this.parseKeystore(reader, ssl, true);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseEngine(XMLExtendedStreamReader reader, ModelNode addOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED_CIPHER_SUITES: {
                    for (String value : reader.getListAttributeValue(i)) {
                        SSLServerIdentityResourceDefinition.ENABLED_CIPHER_SUITES.parseAndAddParameterElement(value, addOperation, (XMLStreamReader)reader);
                    }
                    continue block4;
                }
                case ENABLED_PROTOCOLS: {
                    for (String value : reader.getListAttributeValue(i)) {
                        SSLServerIdentityResourceDefinition.ENABLED_PROTOCOLS.parseAndAddParameterElement(value, addOperation, (XMLStreamReader)reader);
                    }
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseKeystore(XMLExtendedStreamReader reader, ModelNode addOperation, boolean extended) throws XMLStreamException {
        boolean keystorePasswordSet = false;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROVIDER: {
                    KeystoreAttributes.KEYSTORE_PROVIDER.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block9;
                }
                case PATH: {
                    KeystoreAttributes.KEYSTORE_PATH.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block9;
                }
                case KEYSTORE_PASSWORD: {
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    keystorePasswordSet = true;
                    continue block9;
                }
                case RELATIVE_TO: {
                    KeystoreAttributes.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block9;
                }
                case ALIAS: {
                    if (extended) {
                        KeystoreAttributes.ALIAS.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block9;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case KEY_PASSWORD: {
                    if (extended) {
                        KeystoreAttributes.KEY_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block9;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case GENERATE_SELF_SIGNED_CERTIFICATE_HOST: {
                    if (extended) {
                        KeystoreAttributes.GENERATE_SELF_SIGNED_CERTIFICATE_HOST.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block9;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!keystorePasswordSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.KEYSTORE_PASSWORD));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseKerberosIdentity(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode kerberos = new ModelNode();
        kerberos.get("operation").set("add");
        ModelNode kerberosAddress = realmAddress.clone().add("server-identity", "kerberos");
        kerberos.get("address").set(kerberosAddress);
        list.add(kerberos);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case KEYTAB: {
                    this.parseKeyTab(reader, kerberosAddress, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKeyTab(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode keytab = new ModelNode();
        keytab.get("operation").set("add");
        list.add(keytab);
        EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.PRINCIPAL, Attribute.PATH);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case PRINCIPAL: {
                    keytab.get("address").set(parentAddress).add("keytab", value);
                    continue block7;
                }
                case PATH: {
                    KeytabResourceDefinition.PATH.parseAndSetParameter(value, keytab, (XMLStreamReader)reader);
                    continue block7;
                }
                case RELATIVE_TO: {
                    KeytabResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, keytab, (XMLStreamReader)reader);
                    continue block7;
                }
                case FOR_HOSTS: {
                    for (String host : reader.getListAttributeValue(i)) {
                        KeytabResourceDefinition.FOR_HOSTS.parseAndAddParameterElement(host, keytab, (XMLStreamReader)reader);
                    }
                    continue block7;
                }
                case DEBUG: {
                    KeytabResourceDefinition.DEBUG.parseAndSetParameter(value, keytab, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean trustStoreFound = false;
        boolean localFound = false;
        boolean kerberosFound = false;
        boolean usernamePasswordFound = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JAAS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseJaasAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case KERBEROS: {
                    if (kerberosFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseKerberosAuthentication(reader, realmAddress, list);
                    kerberosFound = true;
                    continue block10;
                }
                case LDAP: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseLdapAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case PROPERTIES: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parsePropertiesAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case TRUSTSTORE: {
                    if (trustStoreFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseTruststore(reader, realmAddress, list);
                    trustStoreFound = true;
                    continue block10;
                }
                case USERS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseUsersAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case PLUG_IN: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ModelNode parentAddress = realmAddress.clone().add("authentication");
                    this.parsePlugIn_Authentication(reader, parentAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case LOCAL: {
                    if (localFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseLocalAuthentication(reader, realmAddress, list);
                    localFound = true;
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKerberosAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "kerberos");
        ModelNode kerberos = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(kerberos);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOVE_REALM: {
                    KerberosAuthenticationResourceDefinition.REMOVE_REALM.parseAndSetParameter(value, kerberos, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJaasAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "jaas");
        ModelNode jaas = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(jaas);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (nameFound) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    nameFound = true;
                    JaasAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block4;
                }
                case ASSIGN_GROUPS: {
                    JaasAuthenticationResourceDefinition.ASSIGN_GROUPS.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLdapAuthenticationAttributes(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case ALLOW_EMPTY_PASSWORDS: {
                    LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case USERNAME_LOAD: {
                    LdapAuthenticationResourceDefinition.USERNAME_LOAD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void parseLdapAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        this.parseLdapAuthenticationAttributes(reader, ldapAuthentication);
        ModelNode addLdapCache = null;
        boolean choiceFound = false;
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            if (choiceFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case CACHE: {
                    if (addLdapCache != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    addLdapCache = this.parseLdapCache(reader);
                    continue block5;
                }
                case ADVANCED_FILTER: {
                    choiceFound = true;
                    String filter = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.FILTER.getLocalName());
                    LdapAuthenticationResourceDefinition.ADVANCED_FILTER.parseAndSetParameter(filter, ldapAuthentication, (XMLStreamReader)reader);
                    continue block5;
                }
                case USERNAME_FILTER: {
                    choiceFound = true;
                    String usernameAttr = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ATTRIBUTE.getLocalName());
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(usernameAttr, ldapAuthentication, (XMLStreamReader)reader);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!choiceFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.ADVANCED_FILTER, Element.USERNAME_FILTER));
        }
        if (addLdapCache != null) {
            this.correctCacheAddress(ldapAuthentication, addLdapCache);
            list.add(addLdapCache);
        }
    }

    private ModelNode parseLdapCache(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode addr = new ModelNode();
        ModelNode addCacheOp = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        String type = "by-search-time";
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    if ("by-access-time".equals(value) || "by-search-time".equals(value)) {
                        type = value;
                        continue block6;
                    }
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                }
                case EVICTION_TIME: {
                    LdapCacheResourceDefinition.EVICTION_TIME.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case CACHE_FAILURES: {
                    LdapCacheResourceDefinition.CACHE_FAILURES.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case MAX_CACHE_SIZE: {
                    LdapCacheResourceDefinition.MAX_CACHE_SIZE.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addCacheOp.get("address").add("cache", type);
        return addCacheOp;
    }

    private void correctCacheAddress(ModelNode parentAdd, ModelNode cacheAdd) {
        List addressList = cacheAdd.get("address").asPropertyList();
        ModelNode cacheAddress = parentAdd.get("address").clone();
        for (Property current : addressList) {
            cacheAddress.add(current.getName(), current.getValue().asString());
        }
        cacheAdd.get("address").set(cacheAddress);
    }

    private void parseLocalAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "local");
        ModelNode local = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(local);
        int count = reader.getAttributeCount();
        HashSet<Attribute> attributesFound = new HashSet<Attribute>(count);
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attributesFound.contains(attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attributesFound.add(attribute);
            switch (attribute) {
                case DEFAULT_USER: {
                    LocalAuthenticationResourceDefinition.DEFAULT_USER.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                case ALLOWED_USERS: {
                    LocalAuthenticationResourceDefinition.ALLOWED_USERS.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                case SKIP_GROUP_LOADING: {
                    LocalAuthenticationResourceDefinition.SKIP_GROUP_LOADING.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePropertiesAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthenticationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                case RELATIVE_TO: {
                    PropertiesAuthenticationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                case PLAIN_TEXT: {
                    PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseUsersAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode usersAddress = realmAddress.clone().add("authentication", "users");
        list.add(Util.getEmptyOperation((String)"add", (ModelNode)usersAddress));
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case USER: {
                    this.parseUser(reader, usersAddress, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseUser(XMLExtendedStreamReader reader, ModelNode usersAddress, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.USERNAME.getLocalName());
        String userName = reader.getAttributeValue(0);
        ModelNode userAddress = usersAddress.clone().add("user", userName);
        ModelNode user = Util.getEmptyOperation((String)"add", (ModelNode)userAddress);
        list.add(user);
        String password = null;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PASSWORD: {
                    password = reader.getElementText();
                    UserResourceDefinition.PASSWORD.parseAndSetParameter(password, user, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (password == null) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.PASSWORD));
        }
    }

    private void parseTruststore(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(realmAddress).add("authentication", "truststore");
        this.parseKeystore(reader, op, false);
        list.add(op);
    }

    private void parseAuthorization(XMLExtendedStreamReader reader, ModelNode realmAdd, List<ModelNode> list) throws XMLStreamException {
        ModelNode realmAddress = realmAdd.get("address");
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAP_GROUPS_TO_ROLES: {
                    SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.parseAndSetParameter(value, realmAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean authzFound = false;
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    this.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block9;
                }
                case PLUG_IN: {
                    ModelNode parentAddress = realmAddress.clone().add("authorization");
                    this.parsePlugIn_Authorization(reader, parentAddress, list);
                    authzFound = true;
                    continue block9;
                }
                case LDAP: {
                    this.parseLdapAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapAuthorization(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authorization", "ldap");
        ModelNode ldapAuthorization = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthorization);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthorizationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthorization, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        HashSet<Element> foundElements = new HashSet<Element>();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (!foundElements.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case USERNAME_TO_DN: {
                    this.parseUsernameToDn(reader, addr, list);
                    continue block8;
                }
                case GROUP_SEARCH: {
                    this.parseGroupSearch(reader, addr, list);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseUsernameToDn(XMLExtendedStreamReader reader, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case FORCE: {
                    BaseLdapUserSearchResource.FORCE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode cacheAdd = null;
        ModelNode address = ldapAddress.clone().add("username-to-dn");
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case CACHE: {
                    if (cacheAdd != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    cacheAdd = this.parseLdapCache(reader);
                    continue block10;
                }
                case USERNAME_IS_DN: {
                    filterFound = true;
                    this.parseUsernameIsDn(reader, address, childAdd);
                    continue block10;
                }
                case USERNAME_FILTER: {
                    filterFound = true;
                    this.parseUsernameFilter(reader, address, childAdd);
                    continue block10;
                }
                case ADVANCED_FILTER: {
                    filterFound = true;
                    this.parseAdvancedFilter(reader, address, childAdd);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.USERNAME_IS_DN, Element.USERNAME_FILTER, Element.ADVANCED_FILTER));
        }
        list.add(childAdd);
        if (cacheAdd != null) {
            this.correctCacheAddress(childAdd, cacheAdd);
            list.add(cacheAdd);
        }
    }

    private void parseUsernameIsDn(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("username-is-dn"));
    }

    private void parseUsernameFilter(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    UserSearchResourceDefintion.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    UserSearchResourceDefintion.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case USER_DN_ATTRIBUTE: {
                    UserSearchResourceDefintion.USER_DN_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case ATTRIBUTE: {
                    UserSearchResourceDefintion.ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("username-filter"));
    }

    private void parseAdvancedFilter(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    AdvancedUserSearchResourceDefintion.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    AdvancedUserSearchResourceDefintion.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case USER_DN_ATTRIBUTE: {
                    UserSearchResourceDefintion.USER_DN_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case FILTER: {
                    AdvancedUserSearchResourceDefintion.FILTER.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("advanced-filter"));
    }

    private void parseGroupSearch(XMLExtendedStreamReader reader, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_NAME: {
                    BaseLdapGroupSearchResource.GROUP_NAME.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block11;
                }
                case ITERATIVE: {
                    BaseLdapGroupSearchResource.ITERATIVE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block11;
                }
                case GROUP_DN_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_DN_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block11;
                }
                case GROUP_NAME_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_NAME_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode cacheAdd = null;
        ModelNode address = ldapAddress.clone().add("group-search");
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case CACHE: {
                    if (cacheAdd != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    cacheAdd = this.parseLdapCache(reader);
                    continue block12;
                }
                case GROUP_TO_PRINCIPAL: {
                    filterFound = true;
                    this.parseGroupToPrincipal(reader, address, childAdd);
                    continue block12;
                }
                case PRINCIPAL_TO_GROUP: {
                    filterFound = true;
                    this.parsePrincipalToGroup(reader, address, childAdd);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.GROUP_TO_PRINCIPAL, Element.PRINCIPAL_TO_GROUP));
        }
        list.add(childAdd);
        if (cacheAdd != null) {
            this.correctCacheAddress(childAdd, cacheAdd);
            list.add(cacheAdd);
        }
    }

    private void parseGroupToPrincipalAttributes(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    GroupToPrincipalResourceDefinition.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    GroupToPrincipalResourceDefinition.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case SEARCH_BY: {
                    GroupToPrincipalResourceDefinition.SEARCH_BY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case PREFER_ORIGINAL_CONNECTION: {
                    GroupToPrincipalResourceDefinition.PREFER_ORIGINAL_CONNECTION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
    }

    private void parseGroupToPrincipal(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        this.parseGroupToPrincipalAttributes(reader, addOp);
        boolean elementFound = false;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (elementFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            elementFound = true;
            switch (element) {
                case MEMBERSHIP_FILTER: {
                    this.parseMembershipFilter(reader, addOp);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        addOp.get("address").set(parentAddress.clone().add("group-to-principal"));
    }

    private void parseMembershipFilter(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean principalAttribute = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PRINCIPAL_ATTRIBUTE: {
                    principalAttribute = true;
                    GroupToPrincipalResourceDefinition.PRINCIPAL_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!principalAttribute) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PRINCIPAL_ATTRIBUTE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePrincipalToGroup(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_ATTRIBUTE: {
                    PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case PREFER_ORIGINAL_CONNECTION: {
                    PrincipalToGroupResourceDefinition.PREFER_ORIGINAL_CONNECTION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case SKIP_MISSING_GROUPS: {
                    PrincipalToGroupResourceDefinition.SKIP_MISSING_GROUPS.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("principal-to-group"));
    }

    private void parsePropertiesAuthorization(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authorization", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthorizationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PropertiesAuthorizationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePlugIn_Authentication(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = parentAddress.clone().add("plug-in");
        ModelNode plugIn = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(plugIn);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    PlugInAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, plugIn, (XMLStreamReader)reader);
                    nameFound = true;
                    continue block10;
                }
                case MECHANISM: {
                    PlugInAuthenticationResourceDefinition.MECHANISM.parseAndSetParameter(value, plugIn, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    block12: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
                        Element propertyElement = Element.forName((String)reader.getLocalName());
                        switch (propertyElement) {
                            case PROPERTY: {
                                this.parseProperty(reader, addr, list);
                                continue block12;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePlugIn_Authorization(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = parentAddress.clone().add("plug-in");
        ModelNode plugIn = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(plugIn);
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String plugInName = reader.getAttributeValue(0);
        plugIn.get("name").set(plugInName);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    block7: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
                        Element propertyElement = Element.forName((String)reader.getLocalName());
                        switch (propertyElement) {
                            case PROPERTY: {
                                this.parseProperty(reader, addr, list);
                                continue block7;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProperty(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        boolean addressFound = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(parentAddress).add("property", value);
                    addressFound = true;
                    continue block4;
                }
                case VALUE: {
                    PropertyResourceDefinition.VALUE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!addressFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

