/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.dmr.ModelNode;

public abstract class AttributeMarshaller {
    public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel) {
        return this.isMarshallable(attribute, resourceModel, true);
    }

    public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
        return resourceModel.hasDefined(attribute.getName()) && (marshallDefault || !resourceModel.get(attribute.getName()).equals(attribute.getDefaultValue()));
    }

    public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw ControllerMessages.MESSAGES.couldNotMarshalAttributeAsAttribute(attribute.getName());
    }

    public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw ControllerMessages.MESSAGES.couldNotMarshalAttributeAsElement(attribute.getName());
    }

    public boolean isMarshallableAsElement() {
        return false;
    }
}

