/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.SecurityActions;
import org.jboss.dmr.ModelNode;

class BlockingTimeout {
    public static final String SYSTEM_PROPERTY = "jboss.as.management.blocking.timeout";
    private static final int DEFAULT_TIMEOUT = 300;
    private static final String DEFAULT_TIMEOUT_STRING = Long.toString(300L);
    private static final int SHORT_TIMEOUT = 5000;
    private static String sysPropValue;
    private static int defaultValue;
    private final int blockingTimeout;
    private final int shortTimeout;
    private volatile boolean timeoutDetected;

    BlockingTimeout(ModelNode headerValue) {
        if (headerValue != null && headerValue.isDefined()) {
            Integer opHeaderValue = headerValue.asInt();
            if (opHeaderValue < 1) {
                throw ControllerMessages.MESSAGES.invalidBlockingTimeout(opHeaderValue.longValue(), "blocking-timeout");
            }
            this.blockingTimeout = opHeaderValue * 1000;
        } else {
            this.blockingTimeout = BlockingTimeout.resolveDefaultTimeout();
        }
        this.shortTimeout = Math.min(this.blockingTimeout, 5000);
    }

    private static int resolveDefaultTimeout() {
        String propValue = SecurityActions.getSystemProperty(SYSTEM_PROPERTY, DEFAULT_TIMEOUT_STRING);
        if (sysPropValue == null || !sysPropValue.equals(propValue)) {
            sysPropValue = propValue;
            int number = -1;
            try {
                number = Integer.valueOf(sysPropValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (number > 0) {
                defaultValue = number * 1000;
            } else {
                ControllerLogger.MGMT_OP_LOGGER.invalidDefaultBlockingTimeout(sysPropValue, SYSTEM_PROPERTY, 300L);
                defaultValue = 300000;
            }
        }
        return defaultValue;
    }

    int getBlockingTimeout() {
        return this.timeoutDetected ? this.shortTimeout : this.blockingTimeout;
    }

    void timeoutDetected() {
        this.timeoutDetected = true;
    }
}

