/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.Set;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.ResourceAuthorization;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

class ReadOnlyContext
extends AbstractOperationContext {
    private final int operationId;
    private final ModelControllerImpl controller;
    private final AbstractOperationContext primaryContext;
    private AbstractOperationContext.Step lockStep;

    ReadOnlyContext(ProcessType processType, RunningMode runningMode, ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, boolean booting, AbstractOperationContext primaryContext, ModelControllerImpl controller, int operationId) {
        super(processType, runningMode, transactionControl, processState, booting, controller.getAuditLogger(), controller.getNotificationSupport(), controller);
        this.primaryContext = primaryContext;
        this.controller = controller;
        this.operationId = operationId;
    }

    @Override
    void awaitServiceContainerStability() throws InterruptedException {
    }

    @Override
    ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException {
        throw this.readOnlyContext();
    }

    @Override
    void waitForRemovals() throws InterruptedException {
    }

    @Override
    boolean isReadOnly() {
        return true;
    }

    @Override
    public InputStream getAttachmentStream(int index) {
        throw this.readOnlyContext();
    }

    @Override
    public int getAttachmentStreamCount() {
        return 0;
    }

    @Override
    public boolean isRollbackOnRuntimeFailure() {
        return false;
    }

    @Override
    public boolean isResourceServiceRestartAllowed() {
        return false;
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistration() {
        return this.primaryContext.getResourceRegistration();
    }

    @Override
    public ManagementResourceRegistration getResourceRegistrationForUpdate() {
        throw this.readOnlyContext();
    }

    @Override
    public ImmutableManagementResourceRegistration getRootResourceRegistration() {
        return this.primaryContext.getRootResourceRegistration();
    }

    @Override
    public ServiceRegistry getServiceRegistry(boolean modify) throws UnsupportedOperationException {
        if (modify) {
            throw this.readOnlyContext();
        }
        return this.primaryContext.getServiceRegistry(false);
    }

    @Override
    public ServiceController<?> removeService(ServiceName name) throws UnsupportedOperationException {
        throw this.readOnlyContext();
    }

    @Override
    public void removeService(ServiceController<?> controller) throws UnsupportedOperationException {
        throw this.readOnlyContext();
    }

    @Override
    public ServiceTarget getServiceTarget() throws UnsupportedOperationException {
        return this.primaryContext.getServiceTarget();
    }

    @Override
    public ModelNode readModel(PathAddress address) {
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.readModel(fullAddress);
    }

    @Override
    public ModelNode readModelForUpdate(PathAddress address) {
        throw this.readOnlyContext();
    }

    @Override
    public void acquireControllerLock() {
        if (this.lockStep == null) {
            try {
                this.controller.acquireLock(this.operationId, true);
                this.lockStep = this.activeStep;
            }
            catch (InterruptedException e) {
                this.cancelled = true;
                Thread.currentThread().interrupt();
                throw ControllerMessages.MESSAGES.operationCancelledAsynchronously();
            }
        }
    }

    @Override
    void releaseStepLocks(AbstractOperationContext.Step step) {
        if (step == this.lockStep) {
            this.lockStep = null;
            this.controller.releaseLock(this.operationId);
        }
    }

    @Override
    public Resource createResource(PathAddress address) throws UnsupportedOperationException {
        throw this.readOnlyContext();
    }

    @Override
    public void addResource(PathAddress address, Resource toAdd) {
        throw this.readOnlyContext();
    }

    @Override
    public Resource readResource(PathAddress address) {
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.readResource(fullAddress);
    }

    @Override
    public Resource readResource(PathAddress address, boolean recursive) {
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.readResource(fullAddress, recursive);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address) {
        return this.primaryContext.readResourceFromRoot(address);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
        return this.primaryContext.readResourceFromRoot(address, recursive);
    }

    @Override
    public Resource readResourceForUpdate(PathAddress relativeAddress) {
        throw this.readOnlyContext();
    }

    @Override
    public Resource removeResource(PathAddress relativeAddress) throws UnsupportedOperationException {
        throw this.readOnlyContext();
    }

    @Override
    public Resource getRootResource() {
        return this.primaryContext.getRootResource();
    }

    @Override
    public Resource getOriginalRootResource() {
        return this.primaryContext.getOriginalRootResource();
    }

    @Override
    public boolean isModelAffected() {
        return this.primaryContext.isModelAffected();
    }

    @Override
    public boolean isResourceRegistryAffected() {
        return this.primaryContext.isResourceRegistryAffected();
    }

    @Override
    public boolean isRuntimeAffected() {
        return this.primaryContext.isRuntimeAffected();
    }

    @Override
    public OperationContext.Stage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void report(MessageSeverity severity, String message) {
    }

    @Override
    public boolean markResourceRestarted(PathAddress resource, Object owner) {
        return false;
    }

    @Override
    public boolean revertResourceRestarted(PathAddress resource, Object owner) {
        return false;
    }

    @Override
    public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.primaryContext.resolveExpressions(node);
    }

    @Override
    public <T> T getAttachment(OperationContext.AttachmentKey<T> key) {
        return this.primaryContext.getAttachment(key);
    }

    @Override
    public <T> T attach(OperationContext.AttachmentKey<T> key, T value) {
        throw this.readOnlyContext();
    }

    @Override
    public <T> T attachIfAbsent(OperationContext.AttachmentKey<T> key, T value) {
        throw this.readOnlyContext();
    }

    @Override
    public <T> T detach(OperationContext.AttachmentKey<T> key) {
        throw this.readOnlyContext();
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation) {
        return this.primaryContext.authorize(operation);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, Set<Action.ActionEffect> effects) {
        return this.primaryContext.authorize(operation, effects);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, String attribute, ModelNode currentValue) {
        return this.primaryContext.authorize(operation, attribute, currentValue);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, String attribute, ModelNode currentValue, Set<Action.ActionEffect> effects) {
        return this.primaryContext.authorize(operation, attribute, currentValue, effects);
    }

    IllegalStateException readOnlyContext() {
        return ControllerMessages.MESSAGES.readOnlyContext();
    }

    @Override
    public AuthorizationResult authorizeOperation(ModelNode operation) {
        return this.primaryContext.authorizeOperation(operation);
    }

    @Override
    public ResourceAuthorization authorizeResource(boolean attributes, boolean isDefaultResource) {
        return this.primaryContext.authorizeResource(attributes, isDefaultResource);
    }

    @Override
    public void emit(Notification notification) {
        this.primaryContext.emit(notification);
    }

    @Override
    Resource getModel() {
        return this.primaryContext.getModel();
    }
}

