/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.access.Caller;

class SecurityActions {
    SecurityActions() {
    }

    static String getSystemProperty(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    static ClassLoader setThreadContextClassLoader(Class cl) {
        if (System.getSecurityManager() == null) {
            return SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl);
        }
        return SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl);
    }

    static void setThreadContextClassLoader(ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl);
        } else {
            SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl);
        }
    }

    static Caller getCaller(Caller currentCaller) {
        AccessControlContext acc = AccessController.getContext();
        return SecurityActions.createCallerActions().getCaller(acc, currentCaller);
    }

    static Subject getSubject(Caller caller) {
        return SecurityActions.createCallerActions().getSubject(caller);
    }

    static AccessAuditContext currentAccessAuditContext() {
        return SecurityActions.createAccessAuditContextActions().currentContext();
    }

    private static AccessAuditContextActions createAccessAuditContextActions() {
        return System.getSecurityManager() != null ? AccessAuditContextActions.PRIVILEGED : AccessAuditContextActions.NON_PRIVILEGED;
    }

    private static CallerActions createCallerActions() {
        return System.getSecurityManager() != null ? CallerActions.PRIVILEGED : CallerActions.NON_PRIVILEGED;
    }

    private static interface CallerActions {
        public static final CallerActions NON_PRIVILEGED = new CallerActions(){

            @Override
            public Caller getCaller(AccessControlContext acc, Caller currentCaller) {
                Subject subject = Subject.getSubject(acc);
                if (currentCaller == null || subject != currentCaller.getSubject()) {
                    if (subject != null) {
                        subject.setReadOnly();
                    }
                    return Caller.createCaller(subject);
                }
                return currentCaller;
            }

            @Override
            public Subject getSubject(Caller caller) {
                return caller.getSubject();
            }
        };
        public static final CallerActions PRIVILEGED = new CallerActions(){

            @Override
            public Caller getCaller(final AccessControlContext acc, final Caller currentCaller) {
                return AccessController.doPrivileged(new PrivilegedAction<Caller>(){

                    @Override
                    public Caller run() {
                        return NON_PRIVILEGED.getCaller(acc, currentCaller);
                    }
                });
            }

            @Override
            public Subject getSubject(final Caller caller) {
                return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                    @Override
                    public Subject run() {
                        return NON_PRIVILEGED.getSubject(caller);
                    }
                });
            }
        };

        public Caller getCaller(AccessControlContext var1, Caller var2);

        public Subject getSubject(Caller var1);
    }

    private static interface AccessAuditContextActions {
        public static final AccessAuditContextActions NON_PRIVILEGED = new AccessAuditContextActions(){

            @Override
            public AccessAuditContext currentContext() {
                return AccessAuditContext.currentAccessAuditContext();
            }
        };
        public static final AccessAuditContextActions PRIVILEGED = new AccessAuditContextActions(){
            private final PrivilegedAction<AccessAuditContext> PRIVILEGED_ACTION = new PrivilegedAction<AccessAuditContext>(){

                @Override
                public AccessAuditContext run() {
                    return NON_PRIVILEGED.currentContext();
                }
            };

            @Override
            public AccessAuditContext currentContext() {
                return AccessController.doPrivileged(this.PRIVILEGED_ACTION);
            }
        };

        public AccessAuditContext currentContext();
    }

    private static interface SetThreadContextClassLoaderAction {
        public static final SetThreadContextClassLoaderAction NON_PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(Class cl) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl.getClassLoader());
                return old;
            }

            @Override
            public void setThreadContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        };
        public static final SetThreadContextClassLoaderAction PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(final Class cl) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(cl.getClassLoader());
                        return old;
                    }
                });
            }

            @Override
            public void setThreadContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader setThreadContextClassLoader(Class var1);

        public void setThreadContextClassLoader(ClassLoader var1);
    }
}

