/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.spi.core.remoting.Connector;

public final class Topology {
    private final Set<ClusterTopologyListener> topologyListeners = new HashSet<ClusterTopologyListener>();
    private final Executor executor;
    private volatile Object owner;
    private final Map<String, TopologyMemberImpl> topology = new ConcurrentHashMap<String, TopologyMemberImpl>();
    private Map<String, Long> mapDelete;

    public Topology(Object owner) {
        this(owner, new DirectExecutor());
    }

    public Topology(Object owner, Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Executor is required");
        }
        this.executor = executor;
        this.owner = owner;
        if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
            ActiveMQClientLogger.LOGGER.trace("Topology@" + Integer.toHexString(System.identityHashCode(this)) + " CREATE", new Exception("trace"));
        }
    }

    public synchronized void clear() {
        this.topology.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterTopologyListener(ClusterTopologyListener listener) {
        if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
            ActiveMQClientLogger.LOGGER.trace(this + "::Adding topology listener " + listener, new Exception("Trace"));
        }
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            this.topologyListeners.add(listener);
        }
        this.sendTopology(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
            ActiveMQClientLogger.LOGGER.trace(this + "::Removing topology listener " + listener, new Exception("Trace"));
        }
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            this.topologyListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsLive(String nodeId, TopologyMemberImpl memberInput) {
        Topology topology = this;
        synchronized (topology) {
            if (ActiveMQClientLogger.LOGGER.isDebugEnabled()) {
                ActiveMQClientLogger.LOGGER.debug(this + "::node " + nodeId + "=" + memberInput);
            }
            memberInput.setUniqueEventID(System.currentTimeMillis());
            this.topology.remove(nodeId);
            this.topology.put(nodeId, memberInput);
            this.sendMemberUp(nodeId, memberInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendNode(String nodeId) {
        Topology topology = this;
        synchronized (topology) {
            TopologyMemberImpl memberInput = this.topology.get(nodeId);
            if (memberInput != null) {
                memberInput.setUniqueEventID(System.currentTimeMillis());
                this.sendMemberUp(nodeId, memberInput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyMemberImpl updateBackup(TopologyMemberImpl memberInput) {
        String nodeId = memberInput.getNodeId();
        if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
            ActiveMQClientLogger.LOGGER.trace(this + "::updateBackup::" + nodeId + ", memberInput=" + memberInput);
        }
        Topology topology = this;
        synchronized (topology) {
            TopologyMemberImpl currentMember = this.getMember(nodeId);
            if (currentMember == null) {
                if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQClientLogger.LOGGER.trace("There's no live to be updated on backup update, node=" + nodeId + " memberInput=" + memberInput, new Exception("trace"));
                }
                currentMember = memberInput;
                this.topology.put(nodeId, currentMember);
            }
            TopologyMemberImpl newMember = new TopologyMemberImpl(nodeId, currentMember.getBackupGroupName(), currentMember.getScaleDownGroupName(), currentMember.getLive(), memberInput.getBackup());
            newMember.setUniqueEventID(System.currentTimeMillis());
            this.topology.remove(nodeId);
            this.topology.put(nodeId, newMember);
            this.sendMemberUp(nodeId, newMember);
            return newMember;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMember(long uniqueEventID, String nodeId, TopologyMemberImpl memberInput) {
        Long deleteTme = this.getMapDelete().get(nodeId);
        if (deleteTme != null && uniqueEventID != 0L && uniqueEventID < deleteTme) {
            ActiveMQClientLogger.LOGGER.debug("Update uniqueEvent=" + uniqueEventID + ", nodeId=" + nodeId + ", memberInput=" + memberInput + " being rejected as there was a delete done after that");
            return false;
        }
        Topology topology = this;
        synchronized (topology) {
            TopologyMemberImpl currentMember = this.topology.get(nodeId);
            if (currentMember == null) {
                if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQClientLogger.LOGGER.trace(this + "::NewMemberAdd nodeId=" + nodeId + " member = " + memberInput, new Exception("trace"));
                }
                memberInput.setUniqueEventID(uniqueEventID);
                this.topology.put(nodeId, memberInput);
                this.sendMemberUp(nodeId, memberInput);
                return true;
            }
            if (uniqueEventID > currentMember.getUniqueEventID()) {
                TopologyMemberImpl newMember = new TopologyMemberImpl(nodeId, memberInput.getBackupGroupName(), memberInput.getScaleDownGroupName(), memberInput.getLive(), memberInput.getBackup());
                if (newMember.getLive() == null && currentMember.getLive() != null) {
                    newMember.setLive(currentMember.getLive());
                }
                if (newMember.getBackup() == null && currentMember.getBackup() != null) {
                    newMember.setBackup(currentMember.getBackup());
                }
                if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQClientLogger.LOGGER.trace(this + "::updated currentMember=nodeID=" + nodeId + ", currentMember=" + currentMember + ", memberInput=" + memberInput + "newMember=" + newMember, new Exception("trace"));
                }
                newMember.setUniqueEventID(uniqueEventID);
                this.topology.remove(nodeId);
                this.topology.put(nodeId, newMember);
                this.sendMemberUp(nodeId, newMember);
                return true;
            }
            if (currentMember.getBackup() == null && memberInput.getBackup() != null) {
                currentMember.setBackup(memberInput.getBackup());
            }
            return false;
        }
    }

    private void sendMemberUp(final String nodeId, final TopologyMemberImpl memberToSend) {
        final ArrayList<ClusterTopologyListener> copy = this.copyListeners();
        if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
            ActiveMQClientLogger.LOGGER.trace(this + "::prepare to send " + nodeId + " to " + copy.size() + " elements");
        }
        if (copy.size() > 0) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (ClusterTopologyListener listener : copy) {
                        if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
                            ActiveMQClientLogger.LOGGER.trace(Topology.this + " informing " + listener + " about node up = " + nodeId + " connector = " + memberToSend.getConnector());
                        }
                        try {
                            listener.nodeUP(memberToSend, false);
                        }
                        catch (Throwable e) {
                            ActiveMQClientLogger.LOGGER.errorSendingTopology(e);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ClusterTopologyListener> copyListeners() {
        ArrayList<ClusterTopologyListener> listenersCopy;
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            listenersCopy = new ArrayList<ClusterTopologyListener>(this.topologyListeners);
        }
        return listenersCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeMember(final long uniqueEventID, final String nodeId) {
        TopologyMemberImpl member;
        Topology topology = this;
        synchronized (topology) {
            member = this.topology.get(nodeId);
            if (member != null) {
                if (member.getUniqueEventID() > uniqueEventID) {
                    ActiveMQClientLogger.LOGGER.debug("The removeMember was issued before the node " + nodeId + " was started, ignoring call");
                    member = null;
                } else {
                    this.getMapDelete().put(nodeId, uniqueEventID);
                    member = this.topology.remove(nodeId);
                }
            }
        }
        if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
            ActiveMQClientLogger.LOGGER.trace("removeMember " + this + " removing nodeID=" + nodeId + ", result=" + member + ", size = " + this.topology.size(), new Exception("trace"));
        }
        if (member != null) {
            final ArrayList<ClusterTopologyListener> copy = this.copyListeners();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (ClusterTopologyListener listener : copy) {
                        if (ActiveMQClientLogger.LOGGER.isTraceEnabled()) {
                            ActiveMQClientLogger.LOGGER.trace(this + " informing " + listener + " about node down = " + nodeId);
                        }
                        try {
                            listener.nodeDown(uniqueEventID, nodeId);
                        }
                        catch (Exception e) {
                            ActiveMQClientLogger.LOGGER.errorSendingTopologyNodedown(e);
                        }
                    }
                }
            });
        }
        return member != null;
    }

    public synchronized void sendTopology(final ClusterTopologyListener listener) {
        if (ActiveMQClientLogger.LOGGER.isDebugEnabled()) {
            ActiveMQClientLogger.LOGGER.debug(this + " is sending topology to " + listener);
        }
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap copy;
                int count = 0;
                Topology topology = Topology.this;
                synchronized (topology) {
                    copy = new HashMap(Topology.this.topology);
                }
                for (Map.Entry entry : copy.entrySet()) {
                    if (ActiveMQClientLogger.LOGGER.isDebugEnabled()) {
                        ActiveMQClientLogger.LOGGER.debug(Topology.this + " sending " + (String)entry.getKey() + " / " + ((TopologyMemberImpl)entry.getValue()).getConnector() + " to " + listener);
                    }
                    listener.nodeUP((TopologyMember)entry.getValue(), ++count == copy.size());
                }
            }
        });
    }

    public synchronized TopologyMemberImpl getMember(String nodeID) {
        return this.topology.get(nodeID);
    }

    public synchronized TopologyMemberImpl getMember(TransportConfiguration configuration) {
        for (TopologyMemberImpl member : this.topology.values()) {
            if (!member.isMember(configuration)) continue;
            return member;
        }
        return null;
    }

    public synchronized boolean isEmpty() {
        return this.topology.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TopologyMemberImpl> getMembers() {
        ArrayList<TopologyMemberImpl> members;
        Topology topology = this;
        synchronized (topology) {
            members = new ArrayList<TopologyMemberImpl>(this.topology.values());
        }
        return members;
    }

    synchronized int nodes() {
        int count = 0;
        for (TopologyMemberImpl member : this.topology.values()) {
            if (member.getLive() != null) {
                ++count;
            }
            if (member.getBackup() == null) continue;
            ++count;
        }
        return count;
    }

    public synchronized String describe() {
        return this.describe("");
    }

    private synchronized String describe(String text) {
        StringBuilder desc = new StringBuilder(text + "topology on " + this + ":\n");
        for (Map.Entry<String, TopologyMemberImpl> entry : new HashMap<String, TopologyMemberImpl>(this.topology).entrySet()) {
            desc.append("\t").append(entry.getKey()).append(" => ").append(entry.getValue()).append("\n");
        }
        desc.append("\tnodes=").append(this.nodes()).append("\t").append("members=").append(this.members());
        if (this.topology.isEmpty()) {
            desc.append("\tEmpty");
        }
        return desc.toString();
    }

    private int members() {
        return this.topology.size();
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public TransportConfiguration getBackupForConnector(Connector connector) {
        for (TopologyMemberImpl member : this.topology.values()) {
            if (member.getLive() == null || !connector.isEquivalent(member.getLive().getParams())) continue;
            return member.getBackup();
        }
        return null;
    }

    public String toString() {
        if (this.owner == null) {
            return "Topology@" + Integer.toHexString(System.identityHashCode(this));
        }
        return "Topology@" + Integer.toHexString(System.identityHashCode(this)) + "[owner=" + this.owner + "]";
    }

    private synchronized Map<String, Long> getMapDelete() {
        if (this.mapDelete == null) {
            this.mapDelete = new ConcurrentHashMap<String, Long>();
        }
        return this.mapDelete;
    }

    private static final class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }
}

