/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.as.domain.http.server.ConsoleVersion;
import org.jboss.as.domain.http.server.ResourceHandlerDefinition;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum ConsoleMode {
    CONSOLE{

        @Override
        ResourceHandlerDefinition createConsoleHandler(String slot) throws ModuleLoadException {
            return ConsoleHandler.createConsoleHandler(slot);
        }

        @Override
        public boolean hasConsole() {
            return true;
        }
    }
    ,
    SLAVE_HC{

        @Override
        ResourceHandlerDefinition createConsoleHandler(String slot) throws ModuleLoadException {
            return DisabledConsoleHandler.createNoConsoleForSlave(slot);
        }

        @Override
        public boolean hasConsole() {
            return false;
        }
    }
    ,
    ADMIN_ONLY{

        @Override
        ResourceHandlerDefinition createConsoleHandler(String slot) throws ModuleLoadException {
            return DisabledConsoleHandler.createNoConsoleForAdminMode(slot);
        }

        @Override
        public boolean hasConsole() {
            return false;
        }
    }
    ,
    NO_CONSOLE{

        @Override
        ResourceHandlerDefinition createConsoleHandler(String slot) throws ModuleLoadException {
            return null;
        }

        @Override
        public boolean hasConsole() {
            return false;
        }
    };


    ResourceHandlerDefinition createConsoleHandler(String slot) throws ModuleLoadException {
        throw new IllegalStateException("Not overridden for " + (Object)((Object)this));
    }

    public boolean hasConsole() {
        throw new IllegalStateException("Not overridden for " + (Object)((Object)this));
    }

    static SortedSet<ConsoleVersion> findConsoleVersions(String moduleName) {
        String path = moduleName.replace('.', '/');
        String modulePath = WildFlySecurityManager.getPropertyPrivileged((String)"module.path", null);
        File[] moduleRoots = ConsoleMode.getFiles(modulePath, 0, 0);
        TreeSet<ConsoleVersion> consoleVersions = new TreeSet<ConsoleVersion>();
        for (File root : moduleRoots) {
            File addOns;
            ConsoleMode.findConsoleModules(root, path, consoleVersions);
            File layers = new File(root, "system" + File.separator + "layers");
            File[] children = layers.listFiles();
            if (children != null) {
                for (File child : children) {
                    ConsoleMode.findConsoleModules(child, path, consoleVersions);
                }
            }
            if ((children = (addOns = new File(root, "system" + File.separator + "add-ons")).listFiles()) == null) continue;
            for (File child : children) {
                ConsoleMode.findConsoleModules(child, path, consoleVersions);
            }
        }
        return consoleVersions;
    }

    private static void findConsoleModules(File root, String path, Set<ConsoleVersion> consoleVersions) {
        File module = new File(root, path);
        File[] children = module.listFiles();
        if (children != null) {
            for (File child : children) {
                consoleVersions.add(new ConsoleVersion(child.getName()));
            }
        }
    }

    private static File[] getFiles(String modulePath, int stringIdx, int arrayIdx) {
        File[] files;
        int i = modulePath.indexOf(File.pathSeparatorChar, stringIdx);
        if (i == -1) {
            files = new File[arrayIdx + 1];
            files[arrayIdx] = new File(modulePath.substring(stringIdx)).getAbsoluteFile();
        } else {
            files = ConsoleMode.getFiles(modulePath, i + 1, arrayIdx + 1);
            files[arrayIdx] = new File(modulePath.substring(stringIdx, i)).getAbsoluteFile();
        }
        return files;
    }

    protected static ClassLoader getClassLoader(ModuleLoader moduleLoader, String module, String slot) throws ModuleLoadException {
        ModuleIdentifier id = ModuleIdentifier.create((String)module, (String)slot);
        ModuleClassLoader cl = moduleLoader.loadModule(id).getClassLoader();
        return cl;
    }

    static class DisabledConsoleHandler {
        private static final String ERROR_MODULE = "org.jboss.as.domain-http-error-context";
        private static final String CONTEXT = "/consoleerror";
        private static final String NO_CONSOLE_FOR_SLAVE = "/noConsoleForSlaveDcError.html";
        private static final String NO_CONSOLE_FOR_ADMIN_MODE = "/noConsoleForAdminModeError.html";

        DisabledConsoleHandler() {
        }

        static ResourceHandlerDefinition createConsoleHandler(String slot, String resource) throws ModuleLoadException {
            ClassPathResourceManager cpresource = new ClassPathResourceManager(ConsoleMode.getClassLoader(Module.getCallerModuleLoader(), ERROR_MODULE, slot), "");
            ResourceHandler handler = new ResourceHandler().setAllowed(Predicates.not((Predicate)Predicates.path((String)"META-INF"))).setResourceManager((ResourceManager)cpresource).setDirectoryListingEnabled(false).setCachable(Predicates.falsePredicate());
            PredicateHandler predicateHandler = new PredicateHandler(Predicates.path((String)"/"), (HttpHandler)new RedirectHandler(CONTEXT + resource), (HttpHandler)handler);
            return new ResourceHandlerDefinition(CONTEXT, resource, (HttpHandler)predicateHandler);
        }

        static ResourceHandlerDefinition createNoConsoleForSlave(String slot) throws ModuleLoadException {
            return DisabledConsoleHandler.createConsoleHandler(slot, NO_CONSOLE_FOR_SLAVE);
        }

        static ResourceHandlerDefinition createNoConsoleForAdminMode(String slot) throws ModuleLoadException {
            return DisabledConsoleHandler.createConsoleHandler(slot, NO_CONSOLE_FOR_ADMIN_MODE);
        }
    }

    static class ConsoleHandler {
        private static final String NOCACHE_JS = ".nocache.js";
        private static final String INDEX_HTML = "index.html";
        private static final String APP_HTML = "App.html";
        private static final String CONSOLE_MODULE = "org.jboss.as.console";
        private static final String CONTEXT = "/console";
        private static final String DEFAULT_RESOURCE = "/index.html";

        ConsoleHandler() {
        }

        static ResourceHandlerDefinition createConsoleHandler(String skin) throws ModuleLoadException {
            ClassPathResourceManager resource = new ClassPathResourceManager(ConsoleHandler.findConsoleClassLoader(Module.getCallerModuleLoader(), skin), "");
            ResourceHandler handler = new ResourceHandler().setCacheTime(Integer.valueOf(2678400)).setAllowed(Predicates.not((Predicate)Predicates.path((String)"META-INF"))).setResourceManager((ResourceManager)resource).setDirectoryListingEnabled(false).setCachable(Predicates.not((Predicate)Predicates.suffixes((String[])new String[]{NOCACHE_JS, APP_HTML, INDEX_HTML})));
            SetHeaderHandler frameHandler = new SetHeaderHandler((HttpHandler)handler, "X-Frame-Options", "SAMEORIGIN");
            PredicateHandler predicateHandler = new PredicateHandler(Predicates.path((String)"/"), (HttpHandler)new RedirectHandler("/console/index.html"), (HttpHandler)frameHandler);
            return new ResourceHandlerDefinition(CONTEXT, DEFAULT_RESOURCE, (HttpHandler)predicateHandler);
        }

        static ClassLoader findConsoleClassLoader(ModuleLoader moduleLoader, String consoleSkin) throws ModuleLoadException {
            String moduleName = "org.jboss.as.console." + (consoleSkin == null ? "main" : consoleSkin);
            SortedSet<ConsoleVersion> consoleVersions = ConsoleMode.findConsoleVersions(moduleName);
            for (ConsoleVersion consoleVersion : consoleVersions) {
                try {
                    return ConsoleMode.getClassLoader(moduleLoader, moduleName, consoleVersion.getName());
                }
                catch (ModuleLoadException moduleLoadException) {
                }
            }
            try {
                return ConsoleMode.getClassLoader(moduleLoader, CONSOLE_MODULE, consoleSkin);
            }
            catch (ModuleLoadException moduleLoadException) {
                throw HttpServerLogger.ROOT_LOGGER.consoleModuleNotFoundMsg(moduleName);
            }
        }
    }
}

