/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public final class DeploymentUtils {
    public static List<ResourceRoot> allResourceRoots(DeploymentUnit deploymentUnit) {
        ArrayList<ResourceRoot> roots = new ArrayList<ResourceRoot>();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentRoot != null) {
            roots.add(deploymentRoot);
        }
        roots.addAll(deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS));
        return roots;
    }

    public static Set<String> getDeploymentHexHash(ModelNode deployment) {
        HashSet<String> hashes = new HashSet<String>();
        if (deployment.hasDefined("content")) {
            for (ModelNode contentElement : deployment.get("content").asList()) {
                if (!contentElement.hasDefined("hash")) continue;
                hashes.add(HashUtil.bytesToHexString((byte[])contentElement.get("hash").asBytes()));
            }
        }
        return hashes;
    }

    public static DeploymentUnit getTopDeploymentUnit(DeploymentUnit unit) {
        if (unit == null) {
            throw ServerMessages.MESSAGES.nullInitialDeploymentUnit();
        }
        DeploymentUnit parent = unit.getParent();
        while (parent != null) {
            unit = parent;
            parent = unit.getParent();
        }
        return unit;
    }

    public static boolean skipRepeatedActivation(DeploymentUnit unit, int maxValue) {
        AtomicInteger count = unit.getAttachment(Attachments.DEFERRED_ACTIVATION_COUNT);
        return count != null && count.get() > maxValue;
    }

    public static ServiceName getDeploymentUnitPhaseServiceName(DeploymentUnit depUnit, Phase phase) {
        DeploymentUnit parent = depUnit.getParent();
        if (parent == null) {
            return Services.deploymentUnitName(depUnit.getName(), phase);
        }
        return Services.deploymentUnitName(parent.getName(), depUnit.getName(), phase);
    }

    public static void addDeferredModule(DeploymentUnit depUnit) {
        DeploymentUnit topUnit = DeploymentUtils.getTopDeploymentUnit(depUnit);
        topUnit.addToAttachmentList(Attachments.DEFERRED_MODULES, depUnit.getName());
    }

    public static List<String> getDeferredModules(DeploymentUnit depUnit) {
        DeploymentUnit topUnit = DeploymentUtils.getTopDeploymentUnit(depUnit);
        return topUnit.getAttachmentList(Attachments.DEFERRED_MODULES);
    }

    public static List<byte[]> getDeploymentHash(Resource deployment) {
        return DeploymentUtils.getDeploymentHash(deployment.getModel());
    }

    public static List<byte[]> getDeploymentHash(ModelNode deployment) {
        ArrayList<byte[]> hashes = new ArrayList<byte[]>();
        if (deployment.hasDefined("content")) {
            for (ModelNode contentElement : deployment.get("content").asList()) {
                if (!contentElement.hasDefined("hash")) continue;
                byte[] hash = contentElement.get("hash").asBytes();
                hashes.add(hash);
            }
        }
        return hashes;
    }

    private DeploymentUtils() {
    }
}

