/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.protocol.ProtocolFactory;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractProtocolConfigurationBuilder<P extends Protocol, C extends ProtocolConfiguration<P>>
implements ResourceServiceBuilder<C>,
Value<C>,
ProtocolConfiguration<P>,
Consumer<P> {
    private final String name;
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final InjectedValue<ProtocolDefaults> defaults = new InjectedValue();
    private volatile Map<String, String> properties;
    private volatile String moduleName;
    private volatile Boolean statisticsEnabled;

    protected AbstractProtocolConfigurationBuilder(String name) {
        this.name = name;
    }

    public ServiceBuilder<C> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).addDependency(ProtocolDefaultsBuilder.SERVICE_NAME, ProtocolDefaults.class, this.defaults).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Builder<C> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.moduleName = AbstractProtocolResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.properties = ModelNodes.optionalPropertyList((ModelNode)AbstractProtocolResourceDefinition.Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, model)).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(Property::getName, property -> property.getValue().asString()));
        this.statisticsEnabled = AbstractProtocolResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBooleanOrNull();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public final P createProtocol(ProtocolStackConfiguration stackConfiguration) {
        boolean nativeProtocol = this.moduleName.equals(AbstractProtocolResourceDefinition.Attribute.MODULE.getDefinition().getDefaultValue().asString()) && !this.name.startsWith("org.jgroups.protocols");
        String className = nativeProtocol ? String.join((CharSequence)".", "org.jgroups.protocols", this.name) : this.name;
        try {
            Module module = ((ModuleLoader)this.loader.getValue()).loadModule(this.moduleName);
            Class<Protocol> protocolClass = module.getClassLoader().loadClass(className).asSubclass(Protocol.class);
            Protocol protocol = ProtocolFactory.newInstance(protocolClass);
            Protocol result = nativeProtocol ? ProtocolFactory.TRANSFORMER.apply(protocol) : protocol;
            HashMap<String, String> properties = new HashMap<String, String>(((ProtocolDefaults)this.defaults.getValue()).getProperties(protocolClass));
            properties.putAll(this.properties);
            Configurator.removeDeprecatedProperties((Object)result, properties);
            Configurator.resolveAndAssignFields((Object)result, properties);
            Configurator.resolveAndInvokePropertyMethods((Object)result, properties);
            for (Object object : this.getConfigurableObjects(result)) {
                Configurator.removeDeprecatedProperties((Object)object, properties);
                Configurator.resolveAndAssignFields((Object)object, properties);
                Configurator.resolveAndInvokePropertyMethods((Object)object, properties);
            }
            if (!properties.isEmpty()) {
                JGroupsLogger.ROOT_LOGGER.ignoredProperties(this.name, properties);
            }
            this.accept(result);
            result.enableStats(this.statisticsEnabled != null ? this.statisticsEnabled.booleanValue() : stackConfiguration.isStatisticsEnabled());
            return (P)result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private List<Object> getConfigurableObjects(P protocol) throws Exception {
        PrivilegedExceptionAction<List> action = () -> {
            Method method = Protocol.class.getDeclaredMethod("getConfigurableObjects", new Class[0]);
            method.setAccessible(true);
            try {
                List list = (List)method.invoke(protocol, new Object[0]);
                return list;
            }
            finally {
                method.setAccessible(false);
            }
        };
        try {
            return Optional.ofNullable(WildFlySecurityManager.doUnchecked(action)).orElse(Collections.emptyList());
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }
}

